/*
 * Decompiled with CFR 0.152.
 */
package gui.program;

import com.ur.lang.naming.NamingService;
import com.ur.polyscope.program.ProgramLoadingContext;
import gui.program.ContributableProgramNode;
import gui.program.EntityFactory;
import gui.program.position.NullWaypointProvider;
import gui.program.position.WaypointNode;
import javax.inject.Inject;

public class WaypointNodeProvider
implements com.ur.polyscope.program.nodes.waypoint.WaypointNodeProvider {
    private final NullWaypointProvider nullWaypointProvider;
    private final ProgramLoadingContext programLoadingContext;
    private final EntityFactory entityFactory;
    private final NamingService namingService;

    @Inject
    public WaypointNodeProvider(NullWaypointProvider nullWaypointProvider, ProgramLoadingContext programLoadingContext, EntityFactory entityFactory, NamingService namingService) {
        this.nullWaypointProvider = nullWaypointProvider;
        this.programLoadingContext = programLoadingContext;
        this.entityFactory = entityFactory;
        this.namingService = namingService;
    }

    public com.ur.polyscope.program.nodes.waypoint.WaypointNode get() {
        WaypointNode waypointNode = this.useNullObjectProgramNodeFactory() ? this.nullWaypointProvider.get() : this.entityFactory.createWaypointNode();
        return waypointNode;
    }

    public com.ur.polyscope.program.nodes.waypoint.WaypointNode get(String suggestedName) {
        WaypointNode waypointNode;
        if (this.useNullObjectProgramNodeFactory()) {
            waypointNode = this.nullWaypointProvider.get();
        } else {
            waypointNode = this.entityFactory.createWaypointNode();
            if (suggestedName != null) {
                String uniqueName = this.namingService.makeUniqueName(WaypointNode.class, suggestedName);
                waypointNode.setName(uniqueName);
            }
        }
        return waypointNode;
    }

    private boolean useNullObjectProgramNodeFactory() {
        return this.programLoadingContext.isLoading() || ContributableProgramNode.isCloning();
    }
}

