/*
 * Decompiled with CFR 0.152.
 */
package gui.program.calibration;

import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import gui.program.ProgramRootNode;
import gui.program.calibration.KinematicConversionModel;
import gui.program.calibration.KinematicDataComponent;
import javax.inject.Inject;

public class KinematicConversion {
    private static KinematicConversionModel kinematicConversionModel;
    private static Recipe<KinematicsCalibration> calibrationRecipe;

    @Inject
    public static void setKinematicConversionModel(KinematicConversionModel kinematicConversionModel) {
        KinematicConversion.kinematicConversionModel = kinematicConversionModel;
    }

    @Inject
    public static void setCalibrationRecipe(@Source(value=KinematicsCalibration.class) Recipe<KinematicsCalibration> calibrationRecipe) {
        KinematicConversion.calibrationRecipe = calibrationRecipe;
    }

    public static boolean convertProgram(ProgramRootNode program) {
        return kinematicConversionModel.convertProgram(program);
    }

    public static void attachKinematics(ProgramRootNode program) {
        KinematicsCalibration kinematics = program.getComponent(KinematicDataComponent.class).getKinematics();
        if (kinematics == null) {
            kinematics = (KinematicsCalibration)calibrationRecipe.lastProvider().get();
            program.getComponent(KinematicDataComponent.class).setKinematics(kinematics);
            if (kinematics != null) {
                kinematics.setValidKinematics(false);
            }
        } else {
            kinematics.setValidKinematics(true);
        }
    }
}

