/*
 * Decompiled with CFR 0.152.
 */
package gui.program.calibration;

import com.ur.i18n.TextResource;
import com.ur.lang.EqualsUtil;
import com.ur.monitor.RobotState;
import com.ur.polyscope.program.ProgramModeHolder;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.dialog.DialogReturnValue;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.taskprogress.TaskMonitor;
import com.ur.view.constants.dev.RobotMode;
import com.ur.view.polyscope.program.ProgramCorrectionService;
import gui.installation.services.LookupServiceFacade;
import gui.polyscope.CalibrationModeService;
import gui.program.FileManagementProgramComponent;
import gui.program.ProgramMetaDataComponent;
import gui.program.ProgramRootNode;
import gui.program.calibration.KinematicDataComponent;
import gui.tools.LegacyURDialogCreator;
import javax.inject.Provider;

public abstract class KinematicConversionModel {
    private CalibrationModeService calibrationModeService;
    private KinematicsCalibration kinematics;
    protected TaskMonitor taskMonitor;
    private Provider<ProgramCorrectionService> programCorrectionServiceProvider;
    private Provider<KinematicsCalibration> kinematicsProvider;
    private TextResource textResource;

    public KinematicConversionModel(CalibrationModeService calibrationModeService, TaskMonitor taskMonitor, Provider<ProgramCorrectionService> programCorrectionServiceProvider, Provider<KinematicsCalibration> kinematicsProvider, TextResource textResource) {
        this.calibrationModeService = calibrationModeService;
        this.taskMonitor = taskMonitor;
        this.programCorrectionServiceProvider = programCorrectionServiceProvider;
        this.kinematicsProvider = kinematicsProvider;
        this.textResource = textResource;
    }

    public abstract boolean convertProgram(ProgramRootNode var1);

    public ConfirmationMessage confirmCorrectProgramWaypoints() {
        return new ConfirmationMessage(this.textResource.confirmCorrectProgramWaypointsTitle(), this.textResource.confirmCorrectProgramWaypointsExplanation(), this.textResource.confirmCorrectProgramWaypointsAction(), this.textResource.Cancel());
    }

    protected boolean tryToCorrectTheProgram(ProgramRootNode current, ProgramRootNode programLoaded) {
        if (LookupServiceFacade.get(ProgramModeHolder.class).getMode() != ProgramModeHolder.ProgramMode.Calibration) {
            return false;
        }
        if (!((ProgramCorrectionService)this.programCorrectionServiceProvider.get()).isProgramCorrectionApplicable(current.getComponent(FileManagementProgramComponent.class).getInstallationFileName(), current.getComponent(KinematicDataComponent.class).getKinematics(), current.getComponent(ProgramMetaDataComponent.class).getRobotIdentification())) {
            return false;
        }
        DialogReturnValue applyProgramCorrection = LegacyURDialogCreator.confirmMessageDialog(this.confirmCorrectProgramWaypoints());
        if (applyProgramCorrection == DialogReturnValue.OK) {
            return ((ProgramCorrectionService)this.programCorrectionServiceProvider.get()).applyProgramCorrection(current.getComponent(FileManagementProgramComponent.class).getInstallationFileName(), programLoaded);
        }
        return false;
    }

    protected KinematicsCalibration mostRecentKinematics() {
        RobotState rs = RobotState.getLatestRobotState();
        KinematicsCalibration kinematicsFromController = (KinematicsCalibration)this.kinematicsProvider.get();
        boolean robotOn = EqualsUtil.equalsOneOf((Object)rs.robotMode, (Object[])new RobotMode[]{RobotMode.POWER_ON, RobotMode.IDLE, RobotMode.BACKDRIVE, RobotMode.RUNNING});
        if (kinematicsFromController != null && kinematicsFromController.isValidKinematics() && kinematicsFromController.isValidChecksum() && robotOn) {
            boolean showDialog;
            boolean bl = showDialog = this.calibrationModeService.getMode() != CalibrationModeService.CalibrationMode.CALIBRATION_MODE;
            if (this.kinematics != null && kinematicsFromController.checksumChanged(this.kinematics) && showDialog) {
                ErrorMessage errorMessage = new ErrorMessage(this.textResource.kinematicsHasChanged(), this.textResource.robotIsReplaced(), this.textResource.reloadProgramSuggestion());
                LegacyURDialogCreator.showErrorDialog(errorMessage);
            }
            this.kinematics = kinematicsFromController.clone();
        }
        return this.kinematics;
    }
}

