/*
 * Decompiled with CFR 0.152.
 */
package gui.program.calibration;

import com.ur.i18n.TextResource;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.polyscope.program.ProgramModeHolder;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import com.ur.polyscope.viewfacade.move.InverseKinematicProviderExt;
import com.ur.swing.taskprogress.TaskMonitor;
import com.ur.view.polyscope.program.ProgramCorrectionService;
import gui.installation.services.LookupServiceFacade;
import gui.polyscope.CalibrationModeService;
import gui.program.ProgramRootNode;
import gui.program.ProgramRootNodeLoad;
import gui.program.calibration.KinematicConversionModel;
import gui.program.calibration.KinematicDataComponent;
import gui.program.calibration.ProgramCorrectionKinematicStrategyImpl;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class KinematicConversionModelImpl
extends KinematicConversionModel {
    private final InverseKinematicProviderExt inverseKinematicProviderExt;

    @Inject
    public KinematicConversionModelImpl(CalibrationModeService calibrationModeService, TaskMonitor taskMonitor, Provider<ProgramCorrectionService> programCorrectionServiceProvider, @Source(value=KinematicsCalibration.class) Recipe<KinematicsCalibration> calibrationRecipe, InverseKinematicProviderExt inverseKinematicProviderExt, TextResource textResource) {
        super(calibrationModeService, taskMonitor, programCorrectionServiceProvider, (Provider<KinematicsCalibration>)calibrationRecipe.lastProvider(), textResource);
        this.inverseKinematicProviderExt = inverseKinematicProviderExt;
    }

    @Override
    public boolean convertProgram(ProgramRootNode program) {
        if (LookupServiceFacade.get(ProgramModeHolder.class).getMode() != ProgramModeHolder.ProgramMode.Calibration) {
            return false;
        }
        if (program == null) {
            return false;
        }
        KinematicsCalibration mostRecentKinematics = this.mostRecentKinematics();
        if (mostRecentKinematics == null || !mostRecentKinematics.isValidChecksum()) {
            return false;
        }
        KinematicsCalibration kinematics = program.getComponent(KinematicDataComponent.class).getKinematics();
        if (kinematics == null || !kinematics.isValidChecksum()) {
            program.getComponent(KinematicDataComponent.class).setKinematics(mostRecentKinematics);
            return false;
        }
        boolean checksumChanged = kinematics.checksumChanged(mostRecentKinematics);
        boolean deltaThetaChanged = kinematics.deltaThetaChanged(mostRecentKinematics);
        boolean a_d_alphaChanged = kinematics.changedDHParameters(mostRecentKinematics);
        if (!(checksumChanged || deltaThetaChanged || a_d_alphaChanged)) {
            return false;
        }
        if (checksumChanged) {
            ProgramCorrectionKinematicStrategyImpl strategy = new ProgramCorrectionKinematicStrategyImpl(this.inverseKinematicProviderExt);
            strategy.prepareProgramKinematicsCalibrationForCorrection(ProgramRootNode.get(program), kinematics);
            this.tryToCorrectTheProgram(program, ProgramRootNodeLoad.programLoaded);
        }
        return true;
    }
}

