/*
 * Decompiled with CFR 0.152.
 */
package gui.program.calibration;

import com.ur.monitor.RobotState;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import com.ur.polyscope.program.nodes.move.PositionType;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import com.ur.polyscope.viewfacade.move.InverseKinematicProviderExt;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import gui.program.MotionDefiningNode;
import gui.program.ProgramRootNode;
import gui.program.calibration.ProgramCorrectionKinematicStrategy;
import gui.program.position.MeasuredPosition;
import gui.program.position.WaypointNode;
import java.util.Enumeration;
import javax.inject.Inject;

public class ProgramCorrectionKinematicStrategyImpl
implements ProgramCorrectionKinematicStrategy {
    private final InverseKinematicProviderExt inverseKinematicProviderExt;

    @Inject
    public ProgramCorrectionKinematicStrategyImpl(InverseKinematicProviderExt inverseKinematicProviderExt) {
        this.inverseKinematicProviderExt = inverseKinematicProviderExt;
    }

    @Override
    public boolean prepareProgramKinematicsCalibrationForCorrection(ProgramRootNode program, KinematicsCalibration calibration) {
        Enumeration e = program.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            Pose6d controllerTCPOffset;
            Object o = e.nextElement();
            if (!(o instanceof WaypointNode)) continue;
            WaypointNode waypointNode = (WaypointNode)o;
            MotionDefiningNode motionDefiningNode = waypointNode.getMotionDefiningNode();
            if (waypointNode.getPositionNodeType() != PositionNodeType.FIXED) continue;
            JointPositionVector jpvOriginal = waypointNode.getJointPositionVector();
            Pose6d targetTCPOffset = ((MeasuredPosition)waypointNode.getPositionReferenceClone()).getTCPOffset();
            if (motionDefiningNode == null || motionDefiningNode.getPositionType() == PositionType.JOINT_ANGLES) continue;
            Pose6d pose = waypointNode.getPose6d();
            Pose6d targetToolPoseForControllerTCPOffset = Pose6dTransformUtils.getPoseWithModifiedOffset((Pose6d)pose, (Pose6d)targetTCPOffset, (Pose6d)(controllerTCPOffset = RobotState.getLatestRobotState().tcpOffset));
            JointPositionVector jpvNew = this.inverseKinematicProviderExt.getInverseKinematics(targetToolPoseForControllerTCPOffset, jpvOriginal);
            if (jpvNew == null) {
                jpvNew = new JointPositionVector();
            }
            waypointNode.setPosition(new MeasuredPosition(jpvNew, Pose6dTransformUtils.getTransform3D((Pose6d)targetTCPOffset), calibration));
        }
        return true;
    }
}

