/*
 * Decompiled with CFR 0.152.
 */
package gui.program.direction;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.ProgramNodeType;
import com.ur.polyscope.program.nodes.ProgramNodeTypeImpl;
import com.ur.polyscope.program.nodes.until.MoveThreadScriptParams;
import com.ur.polyscope.program.nodes.until.types.UntilTypeNode;
import com.ur.polyscope.program.undoredo.CompoundProgramChange;
import com.ur.polyscope.program.undoredo.ProgramNodeChange;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.polyscope.scriptwriter.ControllerInterfaceProgramNode;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.valueobjects.Acceleration;
import com.ur.polyscope.valueobjects.Speed;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.swing.expression.ExpressionBranchNode;
import com.ur.util.Optional;
import com.ur.util.logging.Log;
import com.ur.view.program.CommandPanel;
import gui.commandpanels.MoveDirectionCard;
import gui.program.MotionDefiningNode;
import gui.program.MoveChildNode;
import gui.program.direction.DirectionsLookup;
import gui.program.direction.MoveDirectionNode$AjcClosure1;
import gui.program.direction.MoveDirectionNode$AjcClosure11;
import gui.program.direction.MoveDirectionNode$AjcClosure3;
import gui.program.direction.MoveDirectionNode$AjcClosure5;
import gui.program.direction.MoveDirectionNode$AjcClosure7;
import gui.program.direction.MoveDirectionNode$AjcClosure9;
import gui.program.services.geom.GeomFeatureReferenceBase;
import gui.program.until.UntilNode;
import gui.program.until.types.UntilDistanceNode;
import gui.tools.LanguagePack;
import java.util.Enumeration;
import javax.inject.Inject;
import javax.swing.tree.TreeNode;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class MoveDirectionNode
extends MoveChildNode {
    private Optional<GeomFeatureReferenceBase> featureReference = Optional.empty();
    private Optional<DirectionsLookup.Direction> selectedDirection = Optional.of((Object)((Object)DirectionsLookup.Direction.XPlus));
    private Optional<ExpressionBranchNode> expression = Optional.empty();
    private Optional<ToolMotionParams> toolMotionParams = Optional.empty();
    private static final double LARGE_DISTANCE = 1000.0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    @Inject
    public MoveDirectionNode() {
        super((ProgramNodeType)new ProgramNodeTypeImpl(true, true));
    }

    @Override
    public Class<? extends CommandPanel<? extends AbstractProgramNode>> getCardClass() {
        return MoveDirectionCard.class;
    }

    public ScriptWriter generateScriptCode(ScriptWriter writer) {
        this.scriptBegin(writer);
        writer.writeProgramLabel((ControllerInterfaceProgramNode)this);
        if (this.getChildCount() > 0) {
            Optional<UntilDistanceNode> lowestDistanceNode = this.getLowestDistanceNode();
            this.generateMoveThreadCode(writer, lowestDistanceNode);
            this.generateChildrenWithDistance(writer);
        }
        this.scriptEnd(writer);
        return writer;
    }

    private void generateMoveThreadCode(ScriptWriter writer, Optional<UntilDistanceNode> lowestDistanceNode) {
        int id = this.getId();
        String moveThreadFlag = "move_thread_flag_" + id;
        writer.globalVariable(moveThreadFlag, "0");
        writer.defineThread("move_thread_" + id);
        writer.writeScript("enter_critical");
        writer.assign(moveThreadFlag, "1");
        writer.localVariable("towardsPos", String.format("calculate_point_to_move_towards(%s, %s, %s)", this.resolveFeatureReference().dereference().getScriptCode(), this.getDirectionPose(), lowestDistanceNode.isPresent() ? ((UntilDistanceNode)lowestDistanceNode.get()).getDistance().asDouble() : 1000.0));
        ToolMotionParams resolvedToolParams = this.resolveToolMotionParams();
        Optional<String> blendRadius = this.getBlendRadius(lowestDistanceNode);
        if (this.getMotionType() == MotionDefiningNode.MotionType.PROCESS_MOVE) {
            if (blendRadius.isPresent()) {
                writer.movep("towardsPos", MoveDirectionNode.accelerationAsString(resolvedToolParams), MoveDirectionNode.speedAsString(resolvedToolParams), (String)blendRadius.get());
            } else {
                writer.movep("towardsPos", resolvedToolParams.accel.asDouble(), resolvedToolParams.speed.asDouble());
            }
        } else if (blendRadius.isPresent()) {
            writer.movel("towardsPos", MoveDirectionNode.accelerationAsString(resolvedToolParams), MoveDirectionNode.speedAsString(resolvedToolParams), (String)blendRadius.get());
        } else {
            writer.movel("towardsPos", resolvedToolParams.accel.asDouble(), resolvedToolParams.speed.asDouble());
        }
        writer.assign(moveThreadFlag, "2");
        writer.writeScript("exit_critical");
        writer.end();
    }

    private static String speedAsString(ToolMotionParams resolvedToolParams) {
        return String.valueOf(resolvedToolParams.speed.asDouble());
    }

    private static String accelerationAsString(ToolMotionParams resolvedToolParams) {
        return String.valueOf(resolvedToolParams.accel.asDouble());
    }

    private void generateChildrenWithDistance(ScriptWriter writer) {
        int id = this.getId();
        String moveThreadFlag = "move_thread_flag_" + id;
        String moveThread = "move_thread_" + id;
        String moveThreadHandler = "move_thread_han_" + id;
        String moveThreadCondition = String.valueOf(moveThreadFlag) + " > 1";
        writer.assign(moveThreadFlag, "0");
        if (this.shouldRunMoveThread()) {
            writer.runThread(moveThreadHandler, moveThread);
        }
        writer.whileTrue();
        UntilNode distanceNodeNeedToBeLast = null;
        int i = 0;
        while (i < this.getChildCount()) {
            AbstractProgramNode child = (AbstractProgramNode)this.getChildAt(i);
            if (child instanceof UntilNode) {
                UntilNode untilNode = (UntilNode)child;
                if (untilNode.getSelectedTypeNode() instanceof UntilDistanceNode) {
                    distanceNodeNeedToBeLast = untilNode;
                } else if (this.shouldRunMoveThread()) {
                    untilNode.generateScriptCode(writer, new MoveThreadScriptParams(moveThreadHandler, moveThreadCondition));
                } else {
                    untilNode.generateScriptCode(writer);
                }
            }
            ++i;
        }
        if (distanceNodeNeedToBeLast != null) {
            if (this.shouldRunMoveThread()) {
                distanceNodeNeedToBeLast.generateScriptCode(writer, new MoveThreadScriptParams(moveThreadHandler, moveThreadCondition));
            } else {
                distanceNodeNeedToBeLast.generateScriptCode(writer);
            }
        }
        writer.sync();
        writer.end();
    }

    public MotionDefiningNode.MotionType getMotionType() {
        return ((MotionDefiningNode)this.getNodeOfType(MotionDefiningNode.class)).getMotionType();
    }

    public boolean canInsert(TreeNode ancestor) {
        while (ancestor != null && !(ancestor instanceof MotionDefiningNode)) {
            ancestor = ancestor.getParent();
        }
        if (ancestor == null) {
            return false;
        }
        MotionDefiningNode motionDefiningAncestor = (MotionDefiningNode)((Object)ancestor);
        return motionDefiningAncestor.isLinearMove() || motionDefiningAncestor.isProcessMove();
    }

    public boolean isUndefined() {
        boolean isUnsupportedToolSettings;
        if (!this.containsType(MotionDefiningNode.class)) {
            return false;
        }
        boolean isExpressionUndefined = this.expression.isPresent() && ((ExpressionBranchNode)this.expression.get()).isUndefined();
        boolean isFeatureUndefined = false;
        boolean bl = isUnsupportedToolSettings = ((MotionDefiningNode)this.getNodeOfType(MotionDefiningNode.class)).isUsingOptiMove() && !this.getToolMotionParams().isPresent();
        if (this.featureReference.isPresent()) {
            GeomFeature feature = ((GeomFeatureReferenceBase)((Object)this.featureReference.get())).dereference();
            boolean bl2 = isFeatureUndefined = feature == null || feature.isUndefined();
        }
        return isExpressionUndefined || isFeatureUndefined || super.isUndefined() || isUnsupportedToolSettings;
    }

    @ProgramNodeChange
    public void setFeatureReference(Optional<GeomFeatureReferenceBase> featureReference) {
        Optional<GeomFeatureReferenceBase> optional = featureReference;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, optional);
        Object[] objectArray = new Object[]{this, optional, joinPoint};
        MoveDirectionNode$AjcClosure1 moveDirectionNode$AjcClosure1 = new MoveDirectionNode$AjcClosure1(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(moveDirectionNode$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public Optional<GeomFeatureReferenceBase> getFeatureReference() {
        return this.featureReference;
    }

    @ProgramNodeChange
    public void setExpression(Optional<ExpressionBranchNode> expression) {
        Optional<ExpressionBranchNode> optional = expression;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, optional);
        Object[] objectArray = new Object[]{this, optional, joinPoint};
        MoveDirectionNode$AjcClosure3 moveDirectionNode$AjcClosure3 = new MoveDirectionNode$AjcClosure3(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(moveDirectionNode$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    public Optional<ExpressionBranchNode> getExpression() {
        return this.expression;
    }

    @ProgramNodeChange
    public void setSelectedDirection(Optional<DirectionsLookup.Direction> selectedDirection) {
        Optional<DirectionsLookup.Direction> optional = selectedDirection;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, optional);
        Object[] objectArray = new Object[]{this, optional, joinPoint};
        MoveDirectionNode$AjcClosure5 moveDirectionNode$AjcClosure5 = new MoveDirectionNode$AjcClosure5(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(moveDirectionNode$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    public Optional<DirectionsLookup.Direction> getSelectedDirection() {
        return this.selectedDirection;
    }

    @CompoundProgramChange
    public void setExpressionCompound(Optional<ExpressionBranchNode> expression) {
        Optional<ExpressionBranchNode> optional = expression;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, optional);
        Object[] objectArray = new Object[]{this, optional, joinPoint};
        MoveDirectionNode$AjcClosure7 moveDirectionNode$AjcClosure7 = new MoveDirectionNode$AjcClosure7(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(moveDirectionNode$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    @CompoundProgramChange
    public void setDirectionCompound(Optional<DirectionsLookup.Direction> direction) {
        Optional<DirectionsLookup.Direction> optional = direction;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, optional);
        Object[] objectArray = new Object[]{this, optional, joinPoint};
        MoveDirectionNode$AjcClosure9 moveDirectionNode$AjcClosure9 = new MoveDirectionNode$AjcClosure9(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(moveDirectionNode$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    private Optional<UntilDistanceNode> getLowestDistanceNode() {
        double lowestDistance = Double.MAX_VALUE;
        Optional node = Optional.empty();
        Enumeration children = this.children();
        while (children.hasMoreElements()) {
            UntilTypeNode childSelectedNode;
            TreeNode child = (TreeNode)children.nextElement();
            if (!(child instanceof UntilNode) || (childSelectedNode = ((UntilNode)((Object)child)).getSelectedTypeNode()).getType() != UntilTypeNode.Type.DISTANCE || !(((UntilDistanceNode)childSelectedNode).getDistance().asDouble() < lowestDistance)) continue;
            lowestDistance = ((UntilDistanceNode)childSelectedNode).getDistance().asDouble();
            node = Optional.of((Object)((UntilDistanceNode)childSelectedNode));
        }
        return node;
    }

    private Optional<String> getBlendRadius(Optional<UntilDistanceNode> lowestDistanceNode) {
        return lowestDistanceNode.isPresent() && !((UntilDistanceNode)lowestDistanceNode.get()).isUseSharedBlendParameter() ? Optional.of((Object)Double.toString(((UntilDistanceNode)lowestDistanceNode.get()).getBlendRadiusValue().asDouble())) : Optional.empty();
    }

    private boolean shouldRunMoveThread() {
        Optional<UntilDistanceNode> untilDistanceNode = this.getLowestDistanceNode();
        if (!untilDistanceNode.isPresent()) {
            return true;
        }
        return ((UntilDistanceNode)untilDistanceNode.get()).isValidForMoveThread();
    }

    @ProgramNodeChange
    public void setToolMotionParams(Optional<ToolMotionParams> toolMotionParams) {
        Optional<ToolMotionParams> optional = toolMotionParams;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, optional);
        Object[] objectArray = new Object[]{this, optional, joinPoint};
        MoveDirectionNode$AjcClosure11 moveDirectionNode$AjcClosure11 = new MoveDirectionNode$AjcClosure11(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(moveDirectionNode$AjcClosure11.linkClosureAndJoinPoint(69648));
    }

    public Optional<ToolMotionParams> getToolMotionParams() {
        return this.toolMotionParams;
    }

    public ToolMotionParams resolveToolMotionParams() {
        if (this.toolMotionParams.isPresent()) {
            MotionDefiningNode parentMotion = (MotionDefiningNode)this.getNodeOfType(MotionDefiningNode.class);
            this.toolMotionParams = Optional.of((Object)((ToolMotionParams)this.toolMotionParams.get()).updateOptiMove(parentMotion.isUsingOptiMove()));
            return (ToolMotionParams)this.toolMotionParams.get();
        }
        MotionDefiningNode parentMotion = (MotionDefiningNode)this.getNodeOfType(MotionDefiningNode.class);
        return new ToolMotionParams(parentMotion.isUsingOptiMove(), parentMotion.getSpeed(), parentMotion.getAcceleration());
    }

    private GeomFeatureReferenceBase resolveFeatureReference() {
        if (this.featureReference.isPresent()) {
            return (GeomFeatureReferenceBase)((Object)this.featureReference.get());
        }
        MotionDefiningNode motionDefiningNode = (MotionDefiningNode)this.getNodeOfType(MotionDefiningNode.class);
        return motionDefiningNode != null ? motionDefiningNode.getFeatureReference() : null;
    }

    private String getDirectionPose() {
        if (this.getSelectedDirection().isPresent()) {
            return ((DirectionsLookup.Direction)((Object)this.selectedDirection.get())).getPoseString();
        }
        return ((ExpressionBranchNode)this.expression.get()).generateScriptCode();
    }

    public String toString() {
        String label = LanguagePack.getCommandNamesResource().Direction();
        GeomFeatureReferenceBase reference = this.resolveFeatureReference();
        if (reference != null) {
            label = String.valueOf(label) + ": " + (Object)((Object)reference);
        }
        if (this.selectedDirection.isPresent()) {
            label = String.valueOf(label) + (label.contains(":") ? " " + ((DirectionsLookup.Direction)((Object)this.selectedDirection.get())).label : ": " + ((DirectionsLookup.Direction)((Object)this.selectedDirection.get())).label);
        }
        return label;
    }

    public MoveDirectionNode clone() {
        try {
            MoveDirectionNode clone = (MoveDirectionNode)super.clone();
            if (this.expression.isPresent()) {
                clone.expression = Optional.of((Object)((ExpressionBranchNode)this.expression.get()).clone());
            }
            return clone;
        }
        catch (Exception e) {
            Log.error((String)"Cannot clone MoveDirectionNode", (Throwable)e);
            return null;
        }
    }

    static {
        MoveDirectionNode.ajc$preClinit();
    }

    static final /* synthetic */ void setFeatureReference_aroundBody0(MoveDirectionNode ajc$this, Optional featureReference, JoinPoint joinPoint) {
        ajc$this.featureReference = featureReference;
    }

    static final /* synthetic */ void setExpression_aroundBody2(MoveDirectionNode ajc$this, Optional expression, JoinPoint joinPoint) {
        ajc$this.expression = expression;
    }

    static final /* synthetic */ void setSelectedDirection_aroundBody4(MoveDirectionNode ajc$this, Optional selectedDirection, JoinPoint joinPoint) {
        ajc$this.selectedDirection = selectedDirection;
    }

    static final /* synthetic */ void setExpressionCompound_aroundBody6(MoveDirectionNode ajc$this, Optional expression, JoinPoint joinPoint) {
        ajc$this.setExpression((Optional<ExpressionBranchNode>)expression);
        ajc$this.setSelectedDirection((Optional<DirectionsLookup.Direction>)Optional.empty());
    }

    static final /* synthetic */ void setDirectionCompound_aroundBody8(MoveDirectionNode ajc$this, Optional direction, JoinPoint joinPoint) {
        ajc$this.setExpression((Optional<ExpressionBranchNode>)Optional.empty());
        ajc$this.setSelectedDirection((Optional<DirectionsLookup.Direction>)direction);
    }

    static final /* synthetic */ void setToolMotionParams_aroundBody10(MoveDirectionNode ajc$this, Optional toolMotionParams, JoinPoint joinPoint) {
        ajc$this.toolMotionParams = toolMotionParams;
        ajc$this.textHasChanged();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MoveDirectionNode.java", MoveDirectionNode.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setFeatureReference", "gui.program.direction.MoveDirectionNode", "com.ur.util.Optional", "featureReference", "", "void"), 183);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setExpression", "gui.program.direction.MoveDirectionNode", "com.ur.util.Optional", "expression", "", "void"), 192);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSelectedDirection", "gui.program.direction.MoveDirectionNode", "com.ur.util.Optional", "selectedDirection", "", "void"), 201);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setExpressionCompound", "gui.program.direction.MoveDirectionNode", "com.ur.util.Optional", "expression", "", "void"), 210);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDirectionCompound", "gui.program.direction.MoveDirectionNode", "com.ur.util.Optional", "direction", "", "void"), 216);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setToolMotionParams", "gui.program.direction.MoveDirectionNode", "com.ur.util.Optional", "toolMotionParams", "", "void"), 255);
    }

    public static class ToolMotionParams {
        public final boolean usingOptiMove;
        public final Speed speed;
        public final Acceleration accel;

        public ToolMotionParams(boolean usingOptiMove, Speed speed, Acceleration accel) {
            this.usingOptiMove = usingOptiMove;
            this.speed = speed;
            this.accel = accel;
        }

        public ToolMotionParams updateOptiMove(boolean usingOptiMove) {
            if (this.usingOptiMove == usingOptiMove) {
                return this;
            }
            return new ToolMotionParams(usingOptiMove, this.speed, this.accel);
        }
    }
}

