/*
 * Decompiled with CFR 0.152.
 */
package gui.program.expression.persistence;

import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.util.logging.Log;
import com.ur.view.domain.program.expression.ExpressionWaypointNode;
import com.ur.view.domain.program.expression.UnresolvedExpressionWaypointNode;
import gui.polyscope.DashBoard;
import gui.program.ProgramRootNode;
import gui.program.position.WaypointNode;
import java.util.Collections;
import java.util.Map;

public class ExpressionWaypointNodeConversionStrategy
extends ConversionStrategyTemplate<ExpressionWaypointNode> {
    private static final String REFERENCE_NAME = "referenceName";
    private static final String REFERENCE = "reference";

    public ExpressionWaypointNodeConversionStrategy() {
        super(ExpressionWaypointNode.class);
    }

    public void marshal(ExpressionWaypointNode node, PersistWriter writer) {
        WaypointNode waypoint = node.getWaypointNode();
        if (waypoint != null && waypoint.getParent() != null && ProgramRootNode.get(waypoint) != DashBoard.getProgram() && !this.isSuppressedNode(this.getTopNode(waypoint))) {
            waypoint.setParent(null);
            Log.debug((String)("Removed parent for " + waypoint.getName()));
        }
        writer.startNode("Waypoint");
        writer.addAttribute(REFERENCE_NAME, waypoint.getName());
        writer.writeContainedValue((Object)waypoint);
        writer.endNode();
    }

    private AbstractProgramNode getTopNode(AbstractProgramNode node) {
        if (node.getParent() != null) {
            return this.getTopNode((AbstractProgramNode)node.getParent());
        }
        return node;
    }

    private boolean isSuppressedNode(AbstractProgramNode programNode) {
        ProgramRootNode program = DashBoard.getProgram();
        if (program != null) {
            return program.isSuppressed(programNode);
        }
        return false;
    }

    public ExpressionWaypointNode unmarshal(PersistReader reader) {
        ExpressionWaypointNode newNode = new ExpressionWaypointNode(null);
        if (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            if (this.isCircularWaypointReference(reader)) {
                String desiredPosition = reader.getStringAttribute(REFERENCE_NAME);
                newNode = new UnresolvedExpressionWaypointNode(desiredPosition);
            } else {
                WaypointNode waypoint = (WaypointNode)reader.convertContainedValue(WaypointNode.class);
                newNode = new ExpressionWaypointNode(waypoint);
            }
            reader.moveToParentNode();
        }
        return newNode;
    }

    public Map<String, Class<? extends ExpressionWaypointNode>> getClassAliases(boolean forMarshalling) {
        return Collections.singletonMap("ExpressionWaypoint", ExpressionWaypointNode.class);
    }

    private boolean isCircularWaypointReference(PersistReader reader) {
        String reference = reader.getStringAttribute(REFERENCE);
        return reference != null && reference.endsWith("..");
    }
}

