/*
 * Decompiled with CFR 0.152.
 */
package gui.program.expression.persistence;

import com.ur.polyscope.program.nodes.until.types.UntilTypeNode;
import com.ur.swing.expression.ExpressionBranchNode;
import com.ur.swing.expression.ExpressionNode;
import com.ur.view.domain.program.expression.ExpressionWaypointNode;
import com.ur.view.domain.program.expression.UnresolvedExpressionWaypointNode;
import gui.program.ProgramRootNode;
import gui.program.position.WaypointNode;
import gui.program.until.UntilNode;
import gui.program.until.types.UntilExpressionNode;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;

public class UnresolvedWaypoints {
    private UnresolvedWaypoints() {
    }

    public static void substitute(ProgramRootNode result) {
        ArrayList<UnresolvedWaypointInstance> unresolved = new ArrayList<UnresolvedWaypointInstance>();
        HashMap<String, WaypointNode> positions = new HashMap<String, WaypointNode>();
        Enumeration nodes = result.breadthFirstEnumeration();
        while (nodes.hasMoreElements()) {
            UntilTypeNode untilType;
            Object e = nodes.nextElement();
            if (e instanceof UntilNode && (untilType = ((UntilNode)e).getSelectedTypeNode()) instanceof UntilExpressionNode) {
                ExpressionBranchNode expression = ((UntilExpressionNode)untilType).getExpression();
                for (ExpressionNode expressionNode : expression) {
                    if (!(expressionNode instanceof UnresolvedExpressionWaypointNode)) continue;
                    unresolved.add(new UnresolvedWaypointInstance((UnresolvedExpressionWaypointNode)expressionNode, expression));
                }
            }
            if (!(e instanceof WaypointNode)) continue;
            WaypointNode position = (WaypointNode)e;
            positions.put(position.getName(), position);
        }
        for (UnresolvedWaypointInstance unresolvedWaypointInstance : unresolved) {
            String positionName = unresolvedWaypointInstance.node.getPositionName();
            if (!positions.containsKey(positionName)) continue;
            WaypointNode position = (WaypointNode)positions.get(positionName);
            ExpressionWaypointNode newNode = new ExpressionWaypointNode(position);
            unresolvedWaypointInstance.parent.replaceNode((ExpressionNode)unresolvedWaypointInstance.node, (ExpressionNode)newNode);
        }
    }

    private static class UnresolvedWaypointInstance {
        public final UnresolvedExpressionWaypointNode node;
        public final ExpressionBranchNode parent;

        public UnresolvedWaypointInstance(UnresolvedExpressionWaypointNode node, ExpressionBranchNode parent) {
            this.node = node;
            this.parent = parent;
        }
    }
}

