/*
 * Decompiled with CFR 0.152.
 */
package gui.program.expression.persistence_pre_v3_2;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.view.domain.program.expression.ExpressionIONode;
import gui.program.services.ProgramReferenceService;
import java.util.HashMap;
import java.util.Map;

public class ExpressionIONodeConversionStrategy_v3_0
extends ConversionStrategyTemplate<ExpressionIONode> {
    private static final int STANDARD_OUTPUT = 0;
    private static final int STANDARD_INPUT = 1;
    private static final int CONFIGURABLE_OUTPUT = 2;
    private static final int CONFIGURABLE_INPUT = 3;
    private static final int TOOL_OUTPUT = 4;
    private static final int TOOL_INPUT = 5;
    private static final int ANALOG_OUTPUT = 6;
    private static final int ANALOG_INPUT = 7;
    private final IOService ioService;
    private final ProgramReferenceService programReferenceService;

    public ExpressionIONodeConversionStrategy_v3_0(IOService ioService, ProgramReferenceService programReferenceService) {
        super(ExpressionIONode.class);
        this.ioService = ioService;
        this.programReferenceService = programReferenceService;
    }

    public boolean canUnmarshalFrom(PersistReader reader) {
        return reader.getStringAttribute("ioName") == null;
    }

    public void marshal(ExpressionIONode node, PersistWriter writer) {
    }

    public ExpressionIONode unmarshal(PersistReader reader) {
        boolean isInput = false;
        int type = 0;
        int index = 0;
        PinReference pinReference = null;
        while (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            String nodeName = reader.getNodeName();
            if (EqualsUtil.equals((Object)"isInput", (Object)nodeName)) {
                isInput = reader.getBooleanValue();
            } else if (EqualsUtil.equals((Object)"type", (Object)nodeName)) {
                type = reader.getIntegerValue();
            } else if (EqualsUtil.equals((Object)"index", (Object)nodeName)) {
                index = reader.getIntegerValue();
            } else if (EqualsUtil.equals((Object)"euromapSignal", (Object)nodeName)) {
                pinReference = (PinReference)reader.convertContainedValue(PinReference.class);
            } else if (EqualsUtil.equals((Object)"modbusSignalProgramReference", (Object)nodeName)) {
                pinReference = (PinReference)reader.convertContainedValue(PinReference.class);
            }
            reader.moveToParentNode();
        }
        if (pinReference == null) {
            Pin<?> pin = this.getPin(isInput, type, index);
            pinReference = this.programReferenceService.getPinReference(pin);
        }
        return new ExpressionIONode(pinReference);
    }

    public Map<String, Class<? extends ExpressionIONode>> getClassAliases(boolean forMarshalling) {
        if (!forMarshalling) {
            HashMap<String, Class<? extends ExpressionIONode>> result = new HashMap<String, Class<? extends ExpressionIONode>>();
            result.put("gui.program.expression.ExpressionIONode", ExpressionIONode.class);
            result.put("gui.program.expression.ExpressionModbusSignalNode", ExpressionIONode.class);
            result.put("gui.program.expression.ExpressionEuromapSignalNode", ExpressionIONode.class);
            return result;
        }
        return super.getTypeAliases(forMarshalling);
    }

    private Pin<?> getPin(boolean isInput, int type, int index) {
        if (type == 0) {
            if (index > 9) {
                type = isInput ? 7 : 6;
                index -= 10;
            } else if (index > 7) {
                type = isInput ? 5 : 4;
                index -= 8;
            } else {
                type = isInput ? 1 : 0;
            }
        }
        switch (type) {
            case 0: {
                return this.ioService.getStandardDigitalOutputPins()[index];
            }
            case 1: {
                return this.ioService.getStandardDigitalInputPins()[index];
            }
            case 2: {
                return this.ioService.getConfigurableDigitalOutputPins()[index];
            }
            case 3: {
                return this.ioService.getConfigurableDigitalInputPins()[index];
            }
            case 4: {
                return this.ioService.getToolDigitalOutputPins()[index];
            }
            case 5: {
                return this.ioService.getToolDigitalInputPins()[index];
            }
            case 6: {
                return this.ioService.getStandardAnalogOutputPins()[index];
            }
            case 7: {
                return this.ioService.getAllAnalogInputPins()[index];
            }
        }
        throw new IllegalStateException("Not a known type " + type);
    }
}

