/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.persistence.ConversionStrategy;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.ProgramNodeType;
import com.ur.polyscope.program.nodes.ProgramNodeTypeImpl;
import com.ur.polyscope.program.persist.ProgramComponentConversionStrategy;
import gui.program.EntityFactory;
import gui.program.persistence.CircleMoveNodeConversionStrategy;
import gui.program.persistence.ImporterExporter;
import gui.program.persistence.SpecialSequenceNodeConversionStrategy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.MutableTreeNode;

public class AbstractProgramNodeConversionStrategyProxy
extends ConversionStrategyTemplate<AbstractProgramNode> {
    private final List<ConversionStrategy> programNodeConverters = new ArrayList<ConversionStrategy>();

    public AbstractProgramNodeConversionStrategyProxy(EntityFactory entityFactory, Set<ProgramComponentConversionStrategy> programNodeConverters) {
        super(AbstractProgramNode.class);
        for (ProgramComponentConversionStrategy each : programNodeConverters) {
            this.programNodeConverters.add(new WrappedChainingImporterExporter(each));
        }
        this.programNodeConverters.add(new SpecialSequenceNodeConversionStrategy(entityFactory));
        this.programNodeConverters.add(new CircleMoveNodeConversionStrategy(entityFactory));
    }

    public void marshal(AbstractProgramNode toMarshal, PersistWriter writer) {
        if (toMarshal == null) {
            return;
        }
        for (ConversionStrategy each : this.programNodeConverters) {
            if (!each.getSupportedType().isInstance(toMarshal)) continue;
            each.marshal((Object)toMarshal, writer);
            break;
        }
    }

    public AbstractProgramNode unmarshal(PersistReader reader) {
        for (ConversionStrategy each : this.programNodeConverters) {
            if (!each.canUnmarshalFrom(reader)) continue;
            return (AbstractProgramNode)each.unmarshal(reader);
        }
        return null;
    }

    public Map<String, Class<? extends AbstractProgramNode>> getTypeAliases(boolean forMarshalling) {
        HashMap<String, Class<? extends AbstractProgramNode>> map = new HashMap<String, Class<? extends AbstractProgramNode>>();
        for (ConversionStrategy each : this.programNodeConverters) {
            map.putAll(each.getTypeAliases(forMarshalling));
        }
        return map;
    }

    private static class WrappedChainingImporterExporter
    extends ImporterExporter.Template<AbstractProgramNode>
    implements ConversionStrategy<AbstractProgramNode> {
        private static final String CHILDREN_NODE = "children";
        private final ProgramComponentConversionStrategy wrapped;

        public WrappedChainingImporterExporter(ProgramComponentConversionStrategy toWrap) {
            this.wrapped = toWrap;
        }

        public Class<AbstractProgramNode> getSupportedType() {
            return this.wrapped.getSupportedType();
        }

        public boolean canUnmarshalFrom(PersistReader reader) {
            return this.wrapped.canUnmarshalFrom(reader);
        }

        public final void marshal(AbstractProgramNode toMarshal, PersistWriter writer) {
            this.wrapped.marshal((Object)toMarshal, writer);
            this.writeToChildNodes(toMarshal, writer);
        }

        public final AbstractProgramNode unmarshal(PersistReader reader) {
            AbstractProgramNode result = (AbstractProgramNode)this.wrapped.unmarshal(reader);
            result.setProgramNodeType((ProgramNodeType)new ProgramNodeTypeImpl(reader.hasMoreNodes(), false));
            this.tryReadFromChildNode(result, reader);
            return result;
        }

        public Map<String, Class<? extends AbstractProgramNode>> getClassAliases(boolean forMarshalling) {
            return this.wrapped.getClassAliases(forMarshalling);
        }

        public Map<String, Class<? extends AbstractProgramNode>> getTypeAliases(boolean forMarshalling) {
            return this.wrapped.getTypeAliases(forMarshalling);
        }

        @Override
        public void writeToChildNodes(AbstractProgramNode node, PersistWriter writer) {
            if (node.getNodeType().isChildrenAllowed() && node.getChildCount() > 0) {
                writer.startNode(CHILDREN_NODE);
                int i = 0;
                while (i < node.getChildCount()) {
                    writer.writeNodeWithValue((Object)node.getChildAt(i));
                    ++i;
                }
                writer.endNode();
            }
        }

        @Override
        public boolean tryReadFromChildNode(AbstractProgramNode node, PersistReader reader) {
            if (node.getNodeType().isChildrenAllowed()) {
                try {
                    reader.moveToChildNode();
                    if (EqualsUtil.equals((Object)CHILDREN_NODE, (Object)reader.getNodeName())) {
                        this.readChildren(node, reader);
                        return true;
                    }
                }
                finally {
                    reader.moveToParentNode();
                }
            }
            return false;
        }

        protected void readChildren(AbstractProgramNode node, PersistReader reader) {
            while (reader.hasMoreNodes()) {
                reader.moveToChildNode();
                AbstractProgramNode programNode = (AbstractProgramNode)reader.convertContainedValue((Object)node, AbstractProgramNode.class);
                node.add((MutableTreeNode)programNode);
                reader.moveToParentNode();
            }
        }
    }
}

