/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.swing.expression.ExpressionBranchNode;
import com.ur.view.variables.core.ProgramVariable;
import gui.program.EntityFactory;

public abstract class AbstractProgramVariableConversionStrategy<T extends ProgramVariable>
extends ConversionStrategyTemplate<T> {
    public static final String NAME_ATTRIBUTE = "name";
    public static final String OLD_PROGRAM_VARIABLE_NAME_ATTRIBUTE = "variableName";
    public static final String PREFERS_PERSISTENT_VALUE_ATTRIBUTE = "prefersPersistentValue";
    private static final String INIT_EXPRESSION_ATTRIBUTE = "initializeExpression";
    public static final String DESCRIPTION = "description";
    public static final String IS_FAVOURITE = "favourite";
    final EntityFactory entityFactory;

    public AbstractProgramVariableConversionStrategy(Class<T> supportedType, EntityFactory entityFactory) {
        super(supportedType);
        this.entityFactory = entityFactory;
    }

    public boolean canUnmarshalFrom(PersistReader reader) {
        return (reader.getStringAttribute(NAME_ATTRIBUTE) != null || reader.getStringAttribute(OLD_PROGRAM_VARIABLE_NAME_ATTRIBUTE) != null) && reader.getStringAttribute(PREFERS_PERSISTENT_VALUE_ATTRIBUTE) != null;
    }

    public void marshal(ProgramVariable variable, PersistWriter writer) {
        writer.addAttribute(NAME_ATTRIBUTE, variable.getName());
        writer.addAttribute(PREFERS_PERSISTENT_VALUE_ATTRIBUTE, variable.prefersPersistentValue());
        if (variable.getDescription() != null) {
            writer.addAttribute(DESCRIPTION, variable.getDescription());
        }
        writer.addAttribute(IS_FAVOURITE, variable.isFavourite());
        writer.writeNodeWithValue(INIT_EXPRESSION_ATTRIBUTE, (Object)variable.getInitExpression().getExpression());
    }

    public T unmarshal(PersistReader reader) {
        String name = reader.getStringAttribute(NAME_ATTRIBUTE);
        if (name == null) {
            name = reader.getStringAttribute(OLD_PROGRAM_VARIABLE_NAME_ATTRIBUTE);
        }
        T result = this.createVariable(name);
        String description = reader.getStringAttribute(DESCRIPTION);
        if (description != null) {
            ((ProgramVariable)result).setDescription(description);
        }
        ((ProgramVariable)result).setIsFavourite(reader.getBooleanAttribute(IS_FAVOURITE));
        ((ProgramVariable)result).setPrefersPersistentValue(reader.getBooleanAttribute(PREFERS_PERSISTENT_VALUE_ATTRIBUTE));
        if (reader.hasMoreNodes()) {
            ExpressionBranchNode initExpression = (ExpressionBranchNode)reader.readValueFromChildNode(result, ExpressionBranchNode.class);
            ((ProgramVariable)result).setInitExpressionNode(initExpression);
        }
        return result;
    }

    protected abstract T createVariable(String var1);
}

