/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import gui.program.AnchoredSequenceNode;
import gui.program.EntityFactory;
import gui.program.persistence.ProgramNodeConversionStrategyBase;
import gui.program.position.WaypointNode;
import java.util.Collections;
import java.util.Map;

public class AnchoredSequenceNodeConversionStrategy
extends ProgramNodeConversionStrategyBase<AnchoredSequenceNode> {
    private static final String NAME = "name";
    private static final String ANCHOR_WAYPOINT = "anchorWaypoint";
    private final EntityFactory entityFactory;

    public AnchoredSequenceNodeConversionStrategy(EntityFactory entityFactory) {
        super(AnchoredSequenceNode.class);
        this.entityFactory = entityFactory;
    }

    @Override
    public void writeToAttributes(AnchoredSequenceNode node, PersistWriter writer) {
        writer.addAttribute(NAME, node.getName());
    }

    @Override
    public void writeToChildNodes(AnchoredSequenceNode node, PersistWriter writer) {
        writer.writeNodeWithValue(ANCHOR_WAYPOINT, (Object)node.getAnchorWaypointNode());
    }

    @Override
    protected AnchoredSequenceNode createNode(PersistReader reader) {
        return this.entityFactory.createAnchoredSequenceNode();
    }

    @Override
    public void readFromAttributes(AnchoredSequenceNode node, PersistReader reader) {
        node.setName(reader.getStringAttribute(NAME));
    }

    @Override
    public boolean tryReadFromChildNode(AnchoredSequenceNode node, PersistReader reader) {
        if (!EqualsUtil.equals((Object)ANCHOR_WAYPOINT, (Object)reader.getNodeName())) {
            return false;
        }
        node.setAnchorWaypointNode((WaypointNode)reader.convertContainedValue(WaypointNode.class));
        return true;
    }

    @Override
    public Map<String, Class<? extends AnchoredSequenceNode>> getTypeAliases(boolean forMarshalling) {
        return Collections.singletonMap("AnchoredSequence", AnchoredSequenceNode.class);
    }
}

