/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.lang.BijectiveEnumMap;
import com.ur.lang.EqualsUtil;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.swing.expression.ExpressionBranchNode;
import com.ur.view.variables.core.Variable;
import gui.program.AssignmentNode;
import gui.program.EntityFactory;
import gui.program.persistence.ProgramNodeConversionStrategyBase;
import java.util.HashMap;
import java.util.Map;

public class AssignmentNodeConversionStrategy
extends ProgramNodeConversionStrategyBase<AssignmentNode> {
    private static final String VALUE_SOURCE_ATTRIBUTE = "valueSource";
    private static final String ASSIGNMENT_OPERATOR_MESSAGE_ATTRIBUTE = "message";
    private static final String OPERATOR_VALUE_TYPE_ATTRIBUTE = "valueType";
    private static final String VARIABLE_NODE = "variable";
    private static final String EXPRESSION_NODE = "expression";
    private static final BijectiveEnumMap<AssignmentNode.ValueSource, String> VALUE_SOURCE_NAMES = new BijectiveEnumMap(AssignmentNode.ValueSource.class).put((Enum)AssignmentNode.ValueSource.EXPRESSION, (Object)"Expression").put((Enum)AssignmentNode.ValueSource.OPERATOR, (Object)"Operator").seal();
    private static final BijectiveEnumMap<AssignmentNode.OperatorValueType, String> VALUE_TYPE_NAMES = new BijectiveEnumMap(AssignmentNode.OperatorValueType.class).put((Enum)AssignmentNode.OperatorValueType.BOOLEAN, (Object)"Boolean").put((Enum)AssignmentNode.OperatorValueType.INTEGER, (Object)"Integer").put((Enum)AssignmentNode.OperatorValueType.FLOAT, (Object)"Float").put((Enum)AssignmentNode.OperatorValueType.STRING, (Object)"String").seal();
    private final EntityFactory entityFactory;

    public AssignmentNodeConversionStrategy(EntityFactory entityFactory) {
        super(AssignmentNode.class);
        this.entityFactory = entityFactory;
    }

    @Override
    public void writeToAttributes(AssignmentNode node, PersistWriter writer) {
        writer.addAttribute(VALUE_SOURCE_ATTRIBUTE, (String)VALUE_SOURCE_NAMES.getValue((Enum)node.getValueSource()));
        if (node.getValueSource() == AssignmentNode.ValueSource.OPERATOR) {
            writer.addAttribute(ASSIGNMENT_OPERATOR_MESSAGE_ATTRIBUTE, node.getAssignmentOperatorMessage());
            writer.addAttribute(OPERATOR_VALUE_TYPE_ATTRIBUTE, (String)VALUE_TYPE_NAMES.getValue((Enum)node.getOperatorValueType()));
        }
    }

    @Override
    public void writeToChildNodes(AssignmentNode node, PersistWriter writer) {
        this.writeVariable(writer, node);
        if (node.getValueSource() == AssignmentNode.ValueSource.EXPRESSION) {
            this.writeExpression(writer, node);
        }
    }

    @Override
    protected AssignmentNode createNode(PersistReader reader) {
        return this.entityFactory.createAssignmentNode();
    }

    @Override
    public void readFromAttributes(AssignmentNode node, PersistReader reader) {
        node.setValueSource((AssignmentNode.ValueSource)VALUE_SOURCE_NAMES.getKey((Object)reader.getStringAttribute(VALUE_SOURCE_ATTRIBUTE)));
        if (node.getValueSource() == AssignmentNode.ValueSource.OPERATOR) {
            String assignmentOperatorMessage = reader.getStringAttribute(ASSIGNMENT_OPERATOR_MESSAGE_ATTRIBUTE);
            String operatorValueType = reader.getStringAttribute(OPERATOR_VALUE_TYPE_ATTRIBUTE);
            node.setAssignmentOperatorMessage(assignmentOperatorMessage);
            node.setOperatorValueType((AssignmentNode.OperatorValueType)VALUE_TYPE_NAMES.getKey((Object)operatorValueType));
        }
    }

    @Override
    public boolean tryReadFromChildNode(AssignmentNode node, PersistReader reader) {
        String nodeName = reader.getNodeName();
        if (EqualsUtil.equals((Object)VARIABLE_NODE, (Object)nodeName)) {
            this.readVariable(reader, node);
            return true;
        }
        if (EqualsUtil.equals((Object)EXPRESSION_NODE, (Object)nodeName) && node.getValueSource() == AssignmentNode.ValueSource.EXPRESSION) {
            this.readExpression(reader, node);
            return true;
        }
        return false;
    }

    private void writeVariable(PersistWriter writer, AssignmentNode node) {
        writer.writeNodeWithValue(VARIABLE_NODE, (Object)node.getVariable());
    }

    private void writeExpression(PersistWriter writer, AssignmentNode node) {
        writer.writeNodeWithValue(EXPRESSION_NODE, (Object)node.getExpression());
    }

    private void readVariable(PersistReader reader, AssignmentNode node) {
        Variable variable = (Variable)reader.convertContainedValue(Variable.class);
        node.setVariable(variable);
    }

    private void readExpression(PersistReader reader, AssignmentNode node) {
        ExpressionBranchNode expression = (ExpressionBranchNode)reader.convertContainedValue(ExpressionBranchNode.class);
        node.setExpression(expression);
    }

    @Override
    public Map<String, Class<? extends AssignmentNode>> getTypeAliases(boolean forMarshalling) {
        HashMap<String, Class<? extends AssignmentNode>> result = new HashMap<String, Class<? extends AssignmentNode>>();
        result.put("Assignment", AssignmentNode.class);
        return result;
    }
}

