/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import gui.program.CircleMoveNode;
import gui.program.EntityFactory;
import gui.program.persistence.ProgramNodeConversionStrategyBase;
import java.util.Collections;
import java.util.Map;

public class CircleMoveNodeConversionStrategy
extends ProgramNodeConversionStrategyBase<CircleMoveNode> {
    private static final String HTML_NAME = "CircleMove";
    private static final String ORIENTATION_MODE = "OrientationMode";
    private final EntityFactory entityFactory;

    public CircleMoveNodeConversionStrategy(EntityFactory entityFactory) {
        super(CircleMoveNode.class);
        this.entityFactory = entityFactory;
    }

    @Override
    public boolean canUnmarshalFrom(PersistReader reader) {
        String classAttribute = reader.getStringAttribute("class");
        if (classAttribute == null) {
            return true;
        }
        return HTML_NAME.equals(classAttribute);
    }

    @Override
    public void writeToAttributes(CircleMoveNode node, PersistWriter writer) {
        writer.addAttribute(ORIENTATION_MODE, (Enum)node.getOrientationMode());
    }

    @Override
    public void readFromAttributes(CircleMoveNode node, PersistReader reader) {
        String stringAttribute = reader.getStringAttribute(ORIENTATION_MODE);
        if (stringAttribute != null) {
            try {
                CircleMoveNode.OrientationMode orientationMode = CircleMoveNode.OrientationMode.valueOf(stringAttribute);
                node.setOrientationMode(orientationMode);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else {
            node.setOrientationMode(CircleMoveNode.OrientationMode.UNCONSTRAINED);
        }
    }

    @Override
    protected CircleMoveNode createNode(PersistReader reader) {
        return this.entityFactory.createEmptyCircleMoveNode();
    }

    @Override
    public Map<String, Class<? extends CircleMoveNode>> getTypeAliases(boolean forMarshalling) {
        return Collections.singletonMap(HTML_NAME, CircleMoveNode.class);
    }
}

