/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import gui.program.CommentNode;
import gui.program.EntityFactory;
import gui.program.persistence.ProgramNodeConversionStrategyBase;
import java.util.HashMap;
import java.util.Map;

public class CommentNodeConversionStrategy
extends ProgramNodeConversionStrategyBase<CommentNode> {
    public static final String COMMENT_ATTRIBUTE = "comment";
    private final EntityFactory entityFactory;

    public CommentNodeConversionStrategy(EntityFactory entityFactory) {
        super(CommentNode.class);
        this.entityFactory = entityFactory;
    }

    @Override
    public void writeToAttributes(CommentNode node, PersistWriter writer) {
        writer.addAttribute(COMMENT_ATTRIBUTE, node.getCommentString());
    }

    @Override
    protected CommentNode createNode(PersistReader reader) {
        return this.entityFactory.createCommentNode();
    }

    @Override
    public void readFromAttributes(CommentNode node, PersistReader reader) {
        String commentString = reader.getStringAttribute(COMMENT_ATTRIBUTE);
        node.setCommentString(commentString);
    }

    @Override
    public Map<String, Class<? extends CommentNode>> getTypeAliases(boolean forMarshalling) {
        HashMap<String, Class<? extends CommentNode>> result = new HashMap<String, Class<? extends CommentNode>>();
        result.put("Comment", CommentNode.class);
        return result;
    }
}

