/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.swing.expression.ExpressionBranchNode;
import com.ur.view.variables.core.ProgramVariable;
import gui.program.DirectionNode;
import gui.program.EntityFactory;
import gui.program.persistence.ProgramNodeConversionStrategyBase;
import java.util.Collections;
import java.util.Map;

public class DirectionNodeConversionStrategy
extends ProgramNodeConversionStrategyBase<DirectionNode> {
    private static final String STOP_DISTANCE = "stopDistance";
    private static final String STOP_EXPRESSION = "stopExpression";
    private static final String VARIABLE = "variable";
    private final EntityFactory entityFactory;

    public DirectionNodeConversionStrategy(EntityFactory entityFactory) {
        super(DirectionNode.class);
        this.entityFactory = entityFactory;
    }

    @Override
    public void writeToAttributes(DirectionNode node, PersistWriter writer) {
        if (node.isStopAtDistance()) {
            writer.addAttribute(STOP_DISTANCE, node.getMaxDistance());
        }
    }

    @Override
    public void writeToChildNodes(DirectionNode node, PersistWriter writer) {
        if (node.isStopAtExpression()) {
            writer.writeNodeWithValue(STOP_EXPRESSION, (Object)node.getExpression());
        }
        writer.writeNodeWithValue(VARIABLE, (Object)node.getVariable());
    }

    @Override
    protected DirectionNode createNode(PersistReader reader) {
        return this.entityFactory.createDirectionNode();
    }

    @Override
    public void readFromAttributes(DirectionNode node, PersistReader reader) {
        if (reader.getStringAttribute(STOP_DISTANCE) != null) {
            node.setStopAtDistance(true);
            node.setMaxDistance(reader.getDoubleAttribute(STOP_DISTANCE));
        }
    }

    @Override
    public boolean tryReadFromChildNode(DirectionNode node, PersistReader reader) {
        String nodeName = reader.getNodeName();
        if (EqualsUtil.equals((Object)STOP_EXPRESSION, (Object)nodeName)) {
            node.setStopAtExpression(true);
            node.setExpression((ExpressionBranchNode)reader.convertContainedValue(ExpressionBranchNode.class));
        } else if (EqualsUtil.equals((Object)VARIABLE, (Object)nodeName)) {
            node.setVariable((ProgramVariable)reader.convertContainedValue(ProgramVariable.class));
        } else {
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Class<? extends DirectionNode>> getTypeAliases(boolean forMarshalling) {
        return Collections.singletonMap("Direction", DirectionNode.class);
    }
}

