/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.swing.expression.ExpressionBranchNode;
import gui.program.EntityFactory;
import gui.program.EventNode;
import gui.program.persistence.ProgramNodeConversionStrategyBase;
import java.util.Collections;
import java.util.Map;

public class EventNodeConversionStrategy
extends ProgramNodeConversionStrategyBase<EventNode> {
    private static final String EXPRESSION = "expression";
    private final EntityFactory entityFactory;

    public EventNodeConversionStrategy(EntityFactory entityFactory) {
        super(EventNode.class);
        this.entityFactory = entityFactory;
    }

    @Override
    public void writeToChildNodes(EventNode node, PersistWriter writer) {
        this.writeExpression(node, writer);
    }

    @Override
    protected EventNode createNode(PersistReader reader) {
        EventNode result = this.entityFactory.createEventNode();
        result.removeAllChildren();
        return result;
    }

    @Override
    public boolean tryReadFromChildNode(EventNode node, PersistReader reader) {
        if (EqualsUtil.equals((Object)EXPRESSION, (Object)reader.getNodeName())) {
            this.readExpression(reader, node);
            return true;
        }
        return false;
    }

    private void writeExpression(EventNode node, PersistWriter writer) {
        writer.writeNodeWithValue(EXPRESSION, (Object)node.getExpression());
    }

    private void readExpression(PersistReader reader, EventNode result) {
        ExpressionBranchNode ebn = (ExpressionBranchNode)reader.convertContainedValue(ExpressionBranchNode.class);
        result.setExpression(ebn);
    }

    @Override
    public Map<String, Class<? extends EventNode>> getTypeAliases(boolean forMarshalling) {
        return Collections.singletonMap("Event", EventNode.class);
    }
}

