/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.injection.Builder;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.program.ProgramComponent;
import com.ur.polyscope.program.ProgramRootNode;
import com.ur.polyscope.viewfacade.program.persistence.MetaComponentConversionStrategy;
import gui.program.FileManagementProgramComponent;
import javax.inject.Inject;

public class FileManagementComponentConversionStrategy
implements MetaComponentConversionStrategy {
    public static final String INSTALLATION = "installation";
    public static final String DIRECTORY = "directory";
    public static final String INSTALLATION_RELATIVE_PATH = "installationRelativePath";
    private final Builder builder;

    @Inject
    public FileManagementComponentConversionStrategy(Builder builder) {
        this.builder = builder;
    }

    public void writeToAttributes(ProgramRootNode node, PersistWriter writer) {
        FileManagementProgramComponent component = (FileManagementProgramComponent)node.getComponent(FileManagementProgramComponent.class);
        writer.addAttribute(INSTALLATION, component.getInstallationFileName());
        writer.addAttribute(INSTALLATION_RELATIVE_PATH, component.getInstallationRelativePath());
        writer.addAttribute(DIRECTORY, component.getProgramDirectory());
    }

    public ProgramComponent readFromAttributes(PersistReader reader) {
        FileManagementProgramComponent result = (FileManagementProgramComponent)this.builder.get(FileManagementProgramComponent.class);
        String directory = reader.getStringAttribute(DIRECTORY);
        result.setProgramDirectory(directory == null ? "" : directory);
        result.setInstallationFileName(reader.getStringAttribute(INSTALLATION));
        if (reader.getStringAttribute(INSTALLATION_RELATIVE_PATH) == null) {
            result.setInstallationDirectory(reader.getStringAttribute(DIRECTORY));
            result.setAsLegacyProgram(true);
        } else {
            result.setInstallationRelativePath(reader.getStringAttribute(INSTALLATION_RELATIVE_PATH));
            result.setAsLegacyProgram(false);
        }
        return result;
    }
}

