/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import gui.program.EntityFactory;
import gui.program.FolderNode;
import gui.program.persistence.ProgramNodeConversionStrategyBase;
import java.util.Collections;
import java.util.Map;

public class FolderNodeConversionStrategy
extends ProgramNodeConversionStrategyBase<FolderNode> {
    private static final String NAME = "name";
    private static final String KEEP_HIDDEN = "keepHidden";
    private final EntityFactory entityFactory;

    public FolderNodeConversionStrategy(EntityFactory entityFactory) {
        super(FolderNode.class);
        this.entityFactory = entityFactory;
    }

    @Override
    public void writeToAttributes(FolderNode node, PersistWriter writer) {
        writer.addAttribute(NAME, node.getName());
        writer.addAttribute(KEEP_HIDDEN, node.getKeepHidden());
    }

    @Override
    protected FolderNode createNode(PersistReader reader) {
        FolderNode result = this.entityFactory.createFolderNode();
        result.removeAllChildren();
        return result;
    }

    @Override
    public void readFromAttributes(FolderNode node, PersistReader reader) {
        node.setName(reader.getStringAttribute(NAME));
        node.setKeepHidden(reader.getBooleanAttribute(KEEP_HIDDEN));
    }

    @Override
    public Map<String, Class<? extends FolderNode>> getTypeAliases(boolean forMarshalling) {
        return Collections.singletonMap("Folder", FolderNode.class);
    }
}

