/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.lang.BijectiveEnumMap;
import com.ur.lang.EqualsUtil;
import com.ur.polyscope.persistence.InvalidReference;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.util.logging.Log;
import com.ur.view.polyscope.program.ForceType;
import gui.program.EntityFactory;
import gui.program.ForceNode;
import gui.program.persistence.ProgramNodeConversionStrategyBase;
import gui.program.services.geom.GeomFeatureReference;
import java.util.Collections;
import java.util.Map;

public class ForceNodeConversionStrategy
extends ProgramNodeConversionStrategyBase<ForceNode> {
    private static final String TYPE = "type";
    private static final String SELECTION = "selection";
    private static final String WRENCH = "wrench";
    private static final String LIMITS_FORCE = "limitsForce";
    private static final String LIMITS_MOTION = "limitsMotion";
    private static final String GEOM_FEATURE_REFERENCE = "feature";
    private static final BijectiveEnumMap<ForceType, String> FORCE_TYPE_NAMES = new BijectiveEnumMap(ForceType.class).put((Enum)ForceType.SIMPLE, (Object)"Simple").put((Enum)ForceType.FRAME, (Object)"Frame").put((Enum)ForceType.POINT, (Object)"Point").put((Enum)ForceType.MOTION, (Object)"Motion").seal();
    private final EntityFactory entityFactory;

    public ForceNodeConversionStrategy(EntityFactory entityFactory) {
        super(ForceNode.class);
        this.entityFactory = entityFactory;
    }

    @Override
    public void writeToAttributes(ForceNode node, PersistWriter writer) {
        writer.addAttribute(TYPE, (String)FORCE_TYPE_NAMES.getValue((Enum)node.getForceType()));
    }

    @Override
    public void writeToChildNodes(ForceNode node, PersistWriter writer) {
        writer.writeNodeWithValue(GEOM_FEATURE_REFERENCE, (Object)node.getFeatureReference());
        writer.createNodeWithValueAttribute(SELECTION, node.getSelectionVector());
        writer.createNodeWithValueAttribute(WRENCH, node.getWrenchVector());
        writer.createNodeWithValueAttribute(LIMITS_FORCE, node.getForceControlSpeedLimits());
        writer.createNodeWithValueAttribute(LIMITS_MOTION, node.getMotionControlErrorLimits());
    }

    @Override
    protected ForceNode createNode(PersistReader reader) {
        ForceNode result = this.entityFactory.createForceNode();
        result.removeAllChildren();
        return result;
    }

    @Override
    public void readFromAttributes(ForceNode node, PersistReader reader) {
        node.setForceType((ForceType)FORCE_TYPE_NAMES.getKey((Object)reader.getStringAttribute(TYPE)));
    }

    @Override
    public boolean tryReadFromChildNode(ForceNode node, PersistReader reader) {
        String nodeName = reader.getNodeName();
        if (EqualsUtil.equals((Object)GEOM_FEATURE_REFERENCE, (Object)nodeName)) {
            try {
                GeomFeatureReference r = (GeomFeatureReference)((Object)reader.convertContainedValue(GeomFeatureReference.class));
                node.setFeatureReference(r);
            }
            catch (InvalidReference ire) {
                String message = "Exception occurred while reading feature reference ";
                Log.warning((String)message, (Throwable)ire);
            }
        } else if (EqualsUtil.equals((Object)SELECTION, (Object)nodeName)) {
            int[] tmp = reader.getIntegerArrayValueAttribute();
            node.setSelectionVector(tmp);
        } else if (EqualsUtil.equals((Object)WRENCH, (Object)nodeName)) {
            double[] tmp = reader.getDoubleArrayValueAttribute();
            node.setWrenchVector(tmp);
        } else if (EqualsUtil.equals((Object)LIMITS_FORCE, (Object)nodeName)) {
            double[] tmp = reader.getDoubleArrayValueAttribute();
            node.setForceControlSpeedLimits(tmp);
        } else if (EqualsUtil.equals((Object)LIMITS_MOTION, (Object)nodeName)) {
            double[] tmp = reader.getDoubleArrayValueAttribute();
            node.setMotionControlErrorLimits(tmp);
        } else {
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Class<? extends ForceNode>> getTypeAliases(boolean forMarshalling) {
        return Collections.singletonMap("Force", ForceNode.class);
    }
}

