/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import gui.program.persistence_pre_v3_2.GeomFeatureReferenceConversionStrategy_v3_0;
import gui.program.services.GeomFeatureVariable;
import gui.program.services.ProgramReferenceService;
import java.util.Collections;
import java.util.Map;

public class GeomFeatureVariableConversionStrategy
extends ConversionStrategyTemplate<GeomFeatureVariable> {
    public static final String FEATURE_NAME_ATTRIBUTE = "featureName";
    private final ProgramReferenceService programReferenceService;

    public GeomFeatureVariableConversionStrategy(ProgramReferenceService programReferenceService) {
        super(GeomFeatureVariable.class);
        this.programReferenceService = programReferenceService;
    }

    public boolean canUnmarshalFrom(PersistReader reader) {
        return reader.getStringAttribute(FEATURE_NAME_ATTRIBUTE) != null;
    }

    public void marshal(GeomFeatureVariable variable, PersistWriter writer) {
        writer.addAttribute(FEATURE_NAME_ATTRIBUTE, variable.getKey());
    }

    public GeomFeatureVariable unmarshal(PersistReader reader) {
        String featureName = GeomFeatureReferenceConversionStrategy_v3_0.stripTranslationToken(reader.getStringAttribute(FEATURE_NAME_ATTRIBUTE));
        return this.programReferenceService.getGeomFeatureVariable(featureName);
    }

    public Map<String, Class<? extends GeomFeatureVariable>> getClassAliases(boolean forMarshalling) {
        return Collections.singletonMap("GeomFeatureVariable", GeomFeatureVariable.class);
    }
}

