/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.lang.BijectiveEnumMap;
import com.ur.lang.EqualsUtil;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.swing.expression.ExpressionBranchNode;
import gui.program.EntityFactory;
import gui.program.IfNode;
import gui.program.persistence.ProgramNodeConversionStrategyBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class IfNodeConversionStrategy
extends ProgramNodeConversionStrategyBase<IfNode> {
    private static final String TYPE = "type";
    private static final String CHECK_CONTINUOUSLY = "checkContinuously";
    private static final String EXPRESSION = "expression";
    private static final String REMOVED_SIBLINGS = "removedSiblings";
    private static final BijectiveEnumMap<IfNode.Type, String> TYPE_NAMES = new BijectiveEnumMap(IfNode.Type.class).put((Enum)IfNode.Type.IF, (Object)"If").put((Enum)IfNode.Type.ELSE_IF, (Object)"ElseIf").put((Enum)IfNode.Type.ELSE, (Object)"Else").seal();
    private final EntityFactory entityFactory;

    public IfNodeConversionStrategy(EntityFactory entityFactory) {
        super(IfNode.class);
        this.entityFactory = entityFactory;
    }

    @Override
    public void writeToAttributes(IfNode node, PersistWriter writer) {
        writer.addAttribute(TYPE, (String)TYPE_NAMES.getValue((Enum)node.getType()));
        writer.addAttribute(CHECK_CONTINUOUSLY, node.isCheckConditionInSeperateThread());
    }

    @Override
    public void writeToChildNodes(IfNode node, PersistWriter writer) {
        writer.writeNodeWithValue(EXPRESSION, (Object)node.getExpression());
        List<AbstractProgramNode> removedChildrenContainer = node.getRemovedChildrenContainer();
        if (!removedChildrenContainer.isEmpty()) {
            writer.startNode(REMOVED_SIBLINGS);
            for (AbstractProgramNode each : removedChildrenContainer) {
                writer.writeNodeWithValue((Object)each);
            }
            writer.endNode();
        }
    }

    @Override
    protected IfNode createNode(PersistReader reader) {
        IfNode result = this.entityFactory.createIfNode();
        result.removeAllChildren();
        return result;
    }

    @Override
    public void readFromAttributes(IfNode node, PersistReader reader) {
        node.setType((IfNode.Type)TYPE_NAMES.getKey((Object)reader.getStringAttribute(TYPE)));
        node.setCheckConditionInSeperateThread(reader.getBooleanAttribute(CHECK_CONTINUOUSLY));
    }

    @Override
    public boolean tryReadFromChildNode(IfNode node, PersistReader reader) {
        String nodeName = reader.getNodeName();
        if (EqualsUtil.equals((Object)EXPRESSION, (Object)nodeName)) {
            node.setExpression((ExpressionBranchNode)reader.convertContainedValue(ExpressionBranchNode.class));
        } else if (EqualsUtil.equals((Object)REMOVED_SIBLINGS, (Object)nodeName)) {
            ArrayList<AbstractProgramNode> removedSiblings = new ArrayList<AbstractProgramNode>();
            while (reader.hasMoreNodes()) {
                reader.moveToChildNode();
                removedSiblings.add((AbstractProgramNode)reader.convertContainedValue(AbstractProgramNode.class));
                reader.moveToParentNode();
            }
            node.setRemovedSiblingsContainer(removedSiblings);
        } else {
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Class<? extends IfNode>> getTypeAliases(boolean forMarshalling) {
        return Collections.singletonMap("If", IfNode.class);
    }
}

