/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.polyscope.immi.node.CorePullersInNode;
import com.ur.polyscope.immi.node.CorePullersNode;
import com.ur.polyscope.immi.node.CorePullersOutNode;
import com.ur.polyscope.immi.node.EjectorBackNode;
import com.ur.polyscope.immi.node.EjectorForwardNode;
import com.ur.polyscope.immi.node.FreeToMouldNode;
import com.ur.polyscope.immi.node.ImmiNode;
import com.ur.polyscope.immi.node.StartupCheckNode;
import com.ur.polyscope.immi.node.WaitForItemNode;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import gui.program.EntityFactory;
import gui.program.persistence.ProgramNodeConversionStrategyBase;
import java.util.HashMap;
import java.util.Map;

public class ImmiNodeConversionStrategy
extends ProgramNodeConversionStrategyBase<ImmiNode> {
    private static final String STEPS_ENABLED_ATTRIBUTE = "stepsEnabled";
    private static final String CORE_PULLERS_NUMBER_ATTRIBUTE = "corePullersNumber";
    private final EntityFactory entityFactory;

    public ImmiNodeConversionStrategy(EntityFactory entityFactory) {
        super(ImmiNode.class);
        this.entityFactory = entityFactory;
    }

    @Override
    public void writeToAttributes(ImmiNode node, PersistWriter writer) {
        this.writeStepsEnabled(node, writer);
        this.writeCorePullers(node, writer);
    }

    @Override
    protected ImmiNode createNode(PersistReader reader) {
        return this.entityFactory.createImmiNode(reader.getRequiredType());
    }

    @Override
    public void readFromAttributes(ImmiNode node, PersistReader reader) {
        this.readStepsEnabled(node, reader);
        this.readCorePullers(node, reader);
    }

    @Override
    public Map<String, Class<? extends ImmiNode>> getTypeAliases(boolean forMarshalling) {
        HashMap<String, Class<? extends ImmiNode>> result = new HashMap<String, Class<? extends ImmiNode>>();
        result.put("CorePullersIn", CorePullersInNode.class);
        result.put("CorePullersOut", CorePullersOutNode.class);
        result.put("EjectorBack", EjectorBackNode.class);
        result.put("EjectorForward", EjectorForwardNode.class);
        result.put("FreeToMould", FreeToMouldNode.class);
        result.put("StartupCheck", StartupCheckNode.class);
        result.put("WaitForItem", WaitForItemNode.class);
        return result;
    }

    private void writeStepsEnabled(ImmiNode node, PersistWriter writer) {
        writer.addAttribute(STEPS_ENABLED_ATTRIBUTE, node.getStepsEnabled());
    }

    private void readStepsEnabled(ImmiNode node, PersistReader reader) {
        node.setStepsEnabled(reader.getBooleanArrayAttribute(STEPS_ENABLED_ATTRIBUTE));
    }

    private void writeCorePullers(ImmiNode node, PersistWriter writer) {
        if (node instanceof CorePullersNode) {
            CorePullersNode corePullersNode = (CorePullersNode)node;
            writer.addAttribute(CORE_PULLERS_NUMBER_ATTRIBUTE, corePullersNode.getCorePullersNumber());
        }
    }

    private void readCorePullers(ImmiNode node, PersistReader reader) {
        if (node instanceof CorePullersNode) {
            CorePullersNode corePullersNode = (CorePullersNode)node;
            corePullersNode.setCorePullersNumber(reader.getIntegerAttribute(CORE_PULLERS_NUMBER_ATTRIBUTE));
        }
    }
}

