/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.swing.expression.ExpressionBranchNode;
import com.ur.view.variables.core.ProgramVariable;
import com.ur.view.variables.core.Variable;
import gui.program.EntityFactory;
import gui.program.InitVariablesNode;
import gui.program.persistence.ProgramNodeConversionStrategyBase;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class InitVariablesNodeConversionStrategy
extends ProgramNodeConversionStrategyBase<InitVariablesNode> {
    private final EntityFactory entityFactory;
    private static final String XML_GROUP_NAME = "variables";
    private static final String XML_VARIABLE_NODE = "variable";
    private static final String XML_EXPRESSION_NODE = "expression";
    private static final String XML_NAME = "name";

    public InitVariablesNodeConversionStrategy(EntityFactory entityFactory) {
        super(InitVariablesNode.class);
        this.entityFactory = entityFactory;
    }

    @Override
    public void writeToChildNodes(InitVariablesNode node, PersistWriter writer) {
        Collection<Variable> variables = node.getVariables();
        if (this.hasExpression(variables)) {
            writer.startNode(XML_GROUP_NAME);
            for (Variable variable : variables) {
                if (!variable.hasExpression()) continue;
                writer.startNode(XML_VARIABLE_NODE);
                writer.addAttribute(XML_NAME, variable.getName());
                writer.writeNodeWithValue(XML_EXPRESSION_NODE, (Object)variable.getExpression().getExpression());
                writer.endNode();
            }
            writer.endNode();
        }
    }

    private boolean hasExpression(Collection<Variable> variables) {
        for (Variable variable : variables) {
            if (!(variable instanceof ProgramVariable) || !variable.hasExpression()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean tryReadFromChildNode(InitVariablesNode node, PersistReader reader) {
        HashMap<String, ExpressionBranchNode> variables = new HashMap<String, ExpressionBranchNode>();
        String nodeName = reader.getNodeName();
        if (nodeName.equals(XML_GROUP_NAME) && reader.hasMoreNodes()) {
            while (reader.hasMoreNodes()) {
                reader.moveToChildNode();
                String name = reader.getNodeName();
                if (XML_VARIABLE_NODE.equals(name)) {
                    String varName = reader.getStringAttribute(XML_NAME);
                    ExpressionBranchNode initExpression = (ExpressionBranchNode)reader.readValueFromChildNode(ExpressionBranchNode.class);
                    variables.put(varName, initExpression);
                }
                reader.moveToParentNode();
            }
            node.setVariablesMap(variables);
        }
        return true;
    }

    @Override
    protected InitVariablesNode createNode(PersistReader reader) {
        return this.entityFactory.createInitVariablesNode();
    }

    @Override
    public Map<String, Class<? extends InitVariablesNode>> getTypeAliases(boolean forMarshalling) {
        return Collections.singletonMap("InitVariablesNode", InitVariablesNode.class);
    }
}

