/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.view.variables.InstallationVariableReference;
import gui.program.services.ProgramReferenceService;
import java.util.Collections;
import java.util.Map;

public class InstallationVariableConversionStrategy
extends ConversionStrategyTemplate<InstallationVariableReference> {
    private final ProgramReferenceService programReferenceService;

    public InstallationVariableConversionStrategy(ProgramReferenceService programReferenceService) {
        super(InstallationVariableReference.class);
        this.programReferenceService = programReferenceService;
    }

    public boolean canUnmarshalFrom(PersistReader reader) {
        return (reader.getStringAttribute("name") != null || reader.getStringAttribute("variableName") != null) && reader.getStringAttribute("prefersPersistentValue") == null;
    }

    public void marshal(InstallationVariableReference variable, PersistWriter writer) {
        writer.addAttribute("name", variable.getName());
    }

    public InstallationVariableReference unmarshal(PersistReader reader) {
        String name = reader.getStringAttribute("name");
        if (name == null) {
            name = reader.getStringAttribute("variableName");
        }
        return this.programReferenceService.getInstallationVariableReference(name);
    }

    public Map<String, Class<? extends InstallationVariableReference>> getClassAliases(boolean forMarshalling) {
        return Collections.singletonMap("InstallationVariable", InstallationVariableReference.class);
    }
}

