/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsFactory;
import com.ur.view.constants.dev.CalibrationStatus;
import java.util.Collections;
import java.util.Map;

public class KinematicsCalibrationConversionStrategy
extends ConversionStrategyTemplate<KinematicsCalibration> {
    private static final String STATUS = "status";
    private static final String VALID_CHECKSUM = "validChecksum";
    private static final String DELTA_THETA = "deltaTheta";
    private static final String A = "a";
    private static final String D = "d";
    private static final String ALPHA = "alpha";
    private static final String JOINT_CHECKSUM = "jointChecksum";
    private final KinematicsFactory kinematicsFactory;

    public KinematicsCalibrationConversionStrategy(KinematicsFactory kinematicsFactory) {
        super(KinematicsCalibration.class);
        this.kinematicsFactory = kinematicsFactory;
    }

    public void marshal(KinematicsCalibration calibration, PersistWriter writer) {
        writer.addAttribute(STATUS, calibration.getStatus().toString());
        writer.addAttribute(VALID_CHECKSUM, calibration.isValidChecksum());
        writer.createNodeWithValueAttribute(DELTA_THETA, calibration.getDeltaTheta());
        writer.createNodeWithValueAttribute(A, calibration.getA());
        writer.createNodeWithValueAttribute(D, calibration.getD());
        writer.createNodeWithValueAttribute(ALPHA, calibration.getAlpha());
        writer.createNodeWithValueAttribute(JOINT_CHECKSUM, calibration.getJointChecksum());
    }

    public KinematicsCalibration unmarshal(PersistReader reader) {
        CalibrationStatus status = CalibrationStatus.valueOf((String)reader.getStringAttribute(STATUS));
        boolean validChecksum = reader.getBooleanAttribute(VALID_CHECKSUM);
        double[] deltaTheta = null;
        double[] a = null;
        double[] d = null;
        double[] alpha = null;
        int[] jointChecksum = null;
        while (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            String nodeName = reader.getNodeName();
            if (EqualsUtil.equals((Object)DELTA_THETA, (Object)nodeName)) {
                deltaTheta = reader.getDoubleArrayValueAttribute();
            } else if (EqualsUtil.equals((Object)A, (Object)nodeName)) {
                a = reader.getDoubleArrayValueAttribute();
            } else if (EqualsUtil.equals((Object)D, (Object)nodeName)) {
                d = reader.getDoubleArrayValueAttribute();
            } else if (EqualsUtil.equals((Object)ALPHA, (Object)nodeName)) {
                alpha = reader.getDoubleArrayValueAttribute();
            } else if (EqualsUtil.equals((Object)JOINT_CHECKSUM, (Object)nodeName)) {
                jointChecksum = reader.getIntegerArrayValueAttribute();
            }
            reader.moveToParentNode();
        }
        return this.kinematicsFactory.createKinematicsCalibration(deltaTheta, a, d, alpha, jointChecksum, status, validChecksum);
    }

    public Map<String, Class<? extends KinematicsCalibration>> getClassAliases(boolean forMarshalling) {
        return Collections.singletonMap("KinematicsCalibration", KinematicsCalibration.class);
    }
}

