/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.monitor.model.JointPositionVector;
import com.ur.move.Position;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import gui.program.position.LegacyPosition;
import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Point3d;

public class LegacyPositionConversionStrategy
extends ConversionStrategyTemplate<Position> {
    static final String JOINT_POSITION_ATTRIBUTE = "joints";
    static final String POSE_ATTRIBUTE = "pose";

    public LegacyPositionConversionStrategy() {
        super(Position.class);
    }

    public Map<String, Class<? extends Position>> getTypeAliases(boolean forMarshalling) {
        HashMap<String, Class<? extends Position>> result = new HashMap<String, Class<? extends Position>>();
        result.put("Position", LegacyPosition.class);
        return result;
    }

    public void marshal(Position position, PersistWriter writer) {
        JointPositionVector jointPositions = position.getJointPositionVector();
        if (!jointPositions.isUndefined()) {
            writer.addAttribute(JOINT_POSITION_ATTRIBUTE, jointPositions.getJoints());
            Point3d toolPosition = position.getToolPosition();
            Point3d toolAxisAngle = position.getToolAxisAngle();
            writer.addAttribute(POSE_ATTRIBUTE, new double[]{toolPosition.x, toolPosition.y, toolPosition.z, toolAxisAngle.x, toolAxisAngle.y, toolAxisAngle.z});
        }
    }

    public LegacyPosition unmarshal(PersistReader reader) {
        if (reader.hasOneOfAttributes(new String[]{JOINT_POSITION_ATTRIBUTE})) {
            JointPositionVector jointPositions = new JointPositionVector(reader.getDoubleArrayAttribute(JOINT_POSITION_ATTRIBUTE));
            double[] pose = reader.getDoubleArrayAttribute(POSE_ATTRIBUTE);
            return new LegacyPosition(jointPositions, new Point3d(pose[0], pose[1], pose[2]), new Point3d(pose[3], pose[4], pose[5]));
        }
        return new LegacyPosition();
    }
}

