/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import gui.program.persistence.ChainingImporterExporter;
import gui.program.persistence.ChainingImporterExporterImpl;
import gui.program.persistence.LegacySupportImporterExporter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LegacySupportedImporterExporter<T>
extends ChainingImporterExporterImpl<T> {
    private final LegacySupportImporterExporter<? super T> currentImporterExporter;
    private final List<LegacySupportImporterExporter<? super T>> legacyImporterExporters = new ArrayList<LegacySupportImporterExporter<? super T>>();
    private LegacySupportImporterExporter activeImporterExporter;

    public LegacySupportedImporterExporter(LegacySupportImporterExporter<? super T> currentImporterExporter, LegacySupportImporterExporter<? super T> ... legacyImporterExporters) {
        super(null);
        this.currentImporterExporter = currentImporterExporter;
        Collections.addAll(this.legacyImporterExporters, legacyImporterExporters);
    }

    @Override
    public ChainingImporterExporter<? super T> getNext() {
        if (this.activeImporterExporter != null) {
            return this.activeImporterExporter.getNext();
        }
        return this.currentImporterExporter.getNext();
    }

    @Override
    public void writeToAttributes(T node, PersistWriter writer) {
        this.currentImporterExporter.writeToAttributes(node, writer);
    }

    @Override
    public void writeToChildNodes(T node, PersistWriter writer) {
        this.currentImporterExporter.writeToChildNodes(node, writer);
    }

    private LegacySupportImporterExporter getImporterExporter(T node, PersistReader reader) {
        if (this.activeImporterExporter == null) {
            if (this.currentImporterExporter.canReadFrom(node, reader)) {
                this.activeImporterExporter = this.currentImporterExporter;
            } else {
                for (LegacySupportImporterExporter<T> legacyVersion : this.legacyImporterExporters) {
                    if (!legacyVersion.canReadFrom(node, reader)) continue;
                    this.activeImporterExporter = legacyVersion;
                    break;
                }
            }
            if (this.activeImporterExporter == null) {
                this.activeImporterExporter = this.currentImporterExporter;
            }
        }
        return this.activeImporterExporter;
    }

    @Override
    public void readFromAttributes(T node, PersistReader reader) {
        LegacySupportImporterExporter importer = this.getImporterExporter(node, reader);
        if (importer != null) {
            importer.readFromAttributes(node, reader);
        }
    }

    @Override
    public boolean tryReadFromChildNode(T node, PersistReader reader) {
        LegacySupportImporterExporter importer = this.getImporterExporter(node, reader);
        return importer != null && importer.tryReadFromChildNode(node, reader);
    }
}

