/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.lang.BijectiveEnumMap;
import com.ur.lang.EqualsUtil;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.swing.expression.ExpressionBranchNode;
import com.ur.view.variables.core.ProgramVariable;
import com.ur.view.variables.core.Variable;
import gui.program.EntityFactory;
import gui.program.LoopNode;
import gui.program.persistence.ProgramNodeConversionStrategyBase;
import java.util.Collections;
import java.util.Map;

public class LoopNodeConversionStrategy
extends ProgramNodeConversionStrategyBase<LoopNode> {
    private static final String TYPE = "type";
    private static final String COUNT = "count";
    private static final String CHECK_CONTINUOUSLY = "checkContinuously";
    private static final String LOOP_VARIABLE = "loopVariable";
    private static final String EXPRESSION = "expression";
    private static final BijectiveEnumMap<LoopNode.Type, String> TYPE_NAMES = new BijectiveEnumMap(LoopNode.Type.class).put((Enum)LoopNode.Type.FOREVER, (Object)"Forever").put((Enum)LoopNode.Type.COUNTING, (Object)"Counting").put((Enum)LoopNode.Type.WHILE, (Object)"While").seal();
    private final EntityFactory entityFactory;

    public LoopNodeConversionStrategy(EntityFactory entityFactory) {
        super(LoopNode.class);
        this.entityFactory = entityFactory;
    }

    @Override
    public void writeToAttributes(LoopNode node, PersistWriter writer) {
        LoopNode.Type type = node.getType();
        writer.addAttribute(TYPE, (String)TYPE_NAMES.getValue((Enum)type));
        switch (type) {
            case FOREVER: {
                break;
            }
            case COUNTING: {
                writer.addAttribute(COUNT, node.getCount());
                break;
            }
            case WHILE: {
                writer.addAttribute(CHECK_CONTINUOUSLY, node.isCheckConditionInSeperateThread());
            }
        }
    }

    @Override
    public void writeToChildNodes(LoopNode node, PersistWriter writer) {
        switch (node.getType()) {
            case FOREVER: {
                break;
            }
            case COUNTING: {
                writer.writeNodeWithValue(LOOP_VARIABLE, (Object)node.getVariable());
                break;
            }
            case WHILE: {
                writer.writeNodeWithValue(EXPRESSION, (Object)node.getExpression());
            }
        }
    }

    @Override
    protected LoopNode createNode(PersistReader reader) {
        LoopNode result = this.entityFactory.createLoopNode();
        result.removeAllChildren();
        return result;
    }

    @Override
    public void readFromAttributes(LoopNode node, PersistReader reader) {
        LoopNode.Type type = (LoopNode.Type)TYPE_NAMES.getKey((Object)reader.getStringAttribute(TYPE));
        node.setType(type);
        switch (type) {
            case FOREVER: {
                break;
            }
            case COUNTING: {
                node.setCount(reader.getIntegerAttribute(COUNT));
                break;
            }
            case WHILE: {
                node.setCheckConditionInSeperateThread(reader.getBooleanAttribute(CHECK_CONTINUOUSLY));
            }
        }
    }

    @Override
    public boolean tryReadFromChildNode(LoopNode node, PersistReader reader) {
        String nodeName = reader.getNodeName();
        if (EqualsUtil.equals((Object)LOOP_VARIABLE, (Object)nodeName)) {
            node.setVariable((Variable)reader.convertContainedValue(ProgramVariable.class));
        } else if (EqualsUtil.equals((Object)EXPRESSION, (Object)nodeName)) {
            node.setExpression((ExpressionBranchNode)reader.convertContainedValue(ExpressionBranchNode.class));
        } else {
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Class<? extends LoopNode>> getTypeAliases(boolean forMarshalling) {
        return Collections.singletonMap("Loop", LoopNode.class);
    }
}

