/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import gui.program.EntityFactory;
import gui.program.MainProgram;
import gui.program.persistence.ProgramNodeConversionStrategyBase;
import java.util.Collections;
import java.util.Map;

public class MainProgramConversionStrategy
extends ProgramNodeConversionStrategyBase<MainProgram> {
    private static final String RUN_ONLY_ONCE = "runOnlyOnce";
    private static final String INIT_VARIABLES = "InitVariablesNode";
    private final EntityFactory entityFactory;

    public MainProgramConversionStrategy(EntityFactory entityFactory) {
        super(MainProgram.class);
        this.entityFactory = entityFactory;
    }

    @Override
    protected MainProgram createNode(PersistReader reader) {
        MainProgram result = this.entityFactory.createMainProgram();
        result.removeAllChildren();
        return result;
    }

    @Override
    public void writeToAttributes(MainProgram node, PersistWriter writer) {
        writer.addAttribute(RUN_ONLY_ONCE, node.isRunOnlyOnce());
        writer.addAttribute(INIT_VARIABLES, node.isInitVarsEnabled());
    }

    @Override
    public void readFromAttributes(MainProgram node, PersistReader reader) {
        node.setRunOnlyOnce(reader.getBooleanAttribute(RUN_ONLY_ONCE));
        if (reader.hasOneOfAttributes(new String[]{INIT_VARIABLES})) {
            node.setInitVarsEnabled(reader.getBooleanAttribute(INIT_VARIABLES));
        } else {
            node.setInitVarsEnabled(true);
        }
    }

    @Override
    public Map<String, Class<? extends MainProgram>> getTypeAliases(boolean forMarshalling) {
        return Collections.singletonMap("MainProgram", MainProgram.class);
    }
}

