/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.move.Position;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import gui.program.persistence.UnmarshalledPositionRepresentationListener;
import gui.program.position.MeasuredPosition;
import gui.program.position.MeasuredPositionFactory;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Provider;
import javax.vecmath.Point3d;

public class MeasuredPositionConversionStrategy
extends ConversionStrategyTemplate<Position> {
    private static final String JOINT_POSITION_NODE = "JointAngles";
    private static final String JOINT_POSITION_ATTRIBUTE = "angles";
    private static final String TCP_OFFSET_NODE = "TCPOffset";
    private static final String TCP_OFFSET_ATTRIBUTE = "pose";
    private static final String KINEMATICS_NODE = "Kinematics";
    private final Provider<KinematicsCalibration> programKinematicsCalibrationProvider;
    private final UnmarshalledPositionRepresentationListener unmarshalledPositionRepresentationListener;
    private Recipe<KinematicsCalibration> calibrationRecipe;

    public MeasuredPositionConversionStrategy(Provider<KinematicsCalibration> programKinematicsCalibrationProvider, UnmarshalledPositionRepresentationListener unmarshalledPositionRepresentationListener, @Source(value=KinematicsCalibration.class) Recipe<KinematicsCalibration> calibrationRecipe) {
        super(Position.class);
        this.programKinematicsCalibrationProvider = programKinematicsCalibrationProvider;
        this.unmarshalledPositionRepresentationListener = unmarshalledPositionRepresentationListener;
        this.calibrationRecipe = calibrationRecipe;
    }

    public Map<String, Class<? extends Position>> getTypeAliases(boolean forMarshalling) {
        HashMap<String, Class<? extends Position>> result = new HashMap<String, Class<? extends Position>>();
        result.put("Position", MeasuredPosition.class);
        return result;
    }

    public void marshal(Position pos, PersistWriter writer) {
        if (!(pos instanceof MeasuredPosition)) {
            return;
        }
        MeasuredPosition position = (MeasuredPosition)pos;
        JointPositionVector jointPositions = position.getJointPositionVector();
        if (!jointPositions.isUndefined()) {
            writer.startNode(JOINT_POSITION_NODE);
            writer.addAttribute(JOINT_POSITION_ATTRIBUTE, jointPositions.getJoints());
            writer.endNode();
            writer.startNode(TCP_OFFSET_NODE);
            writer.addAttribute(TCP_OFFSET_ATTRIBUTE, position.getTCPOffset().toArray());
            writer.endNode();
            writer.writeNodeWithValue(KINEMATICS_NODE, (Object)position.getCalibration());
        }
    }

    public MeasuredPosition unmarshal(PersistReader reader) {
        if (!reader.hasOneOfAttributes(new String[]{"joints"})) {
            this.unmarshalledPositionRepresentationListener.positionRepresentationIdentified(UnmarshalledPositionRepresentationListener.PositionRepresentation.G5);
            return this.unmarshallMeasuredPose(reader);
        }
        this.unmarshalledPositionRepresentationListener.positionRepresentationIdentified(UnmarshalledPositionRepresentationListener.PositionRepresentation.G3);
        return this.unmarshalG3Position(reader);
    }

    private MeasuredPosition unmarshallMeasuredPose(PersistReader reader) {
        KinematicsCalibration kinematicsCalibration = null;
        double[] joints = null;
        double[] tcpOffset = null;
        while (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            String nodeName = reader.getNodeName();
            if (nodeName.equals(JOINT_POSITION_NODE)) {
                joints = reader.getDoubleArrayAttribute(JOINT_POSITION_ATTRIBUTE);
            } else if (nodeName.equals(TCP_OFFSET_NODE)) {
                tcpOffset = reader.getDoubleArrayAttribute(TCP_OFFSET_ATTRIBUTE);
            } else if (nodeName.equals(KINEMATICS_NODE)) {
                kinematicsCalibration = (KinematicsCalibration)reader.convertContainedValue(KinematicsCalibration.class);
            }
            reader.moveToParentNode();
        }
        if (joints != null && tcpOffset != null && kinematicsCalibration != null) {
            Pose6d offset = new Pose6d(tcpOffset);
            return new MeasuredPosition(new JointPositionVector(joints), Pose6dTransformUtils.getTransform3D((Pose6d)offset), kinematicsCalibration);
        }
        return new MeasuredPosition(this.calibrationRecipe);
    }

    private MeasuredPosition unmarshalG3Position(PersistReader reader) {
        KinematicsCalibration kinematicsCalibration = (KinematicsCalibration)this.programKinematicsCalibrationProvider.get();
        JointPositionVector jointPositions = new JointPositionVector(reader.getDoubleArrayAttribute("joints"));
        double[] pose = reader.getDoubleArrayAttribute(TCP_OFFSET_ATTRIBUTE);
        Point3d toolPosition = new Point3d(pose[0], pose[1], pose[2]);
        Point3d toolAxisAngle = new Point3d(pose[3], pose[4], pose[5]);
        return MeasuredPositionFactory.createMeasuredPosition(jointPositions, toolPosition, toolAxisAngle, kinematicsCalibration);
    }
}

