/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.lang.EqualsUtil;
import com.ur.monitor.model.Pose6d;
import com.ur.move.Position;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import gui.program.EntityFactory;
import gui.program.persistence.WaypointNodeConversionHelper;
import gui.program.persistence.WaypointNodeConversionStrategy;
import gui.program.position.MeasuredPosition;
import gui.program.position.MeasuredWaypointNode;
import gui.program.position.WaypointNode;
import javax.media.j3d.Transform3D;

public class MeasuredWaypointNodeConversionStrategy
extends WaypointNodeConversionStrategy {
    private static final String FEATURE_NODE = "BaseToFeature";
    private final String POSE_ATTRIBUTE = "pose";

    MeasuredWaypointNodeConversionStrategy(EntityFactory entityFactory) {
        super(entityFactory);
    }

    @Override
    Class<? extends Position> getPositionClass() {
        return MeasuredPosition.class;
    }

    @Override
    public void writeToChildNodes(WaypointNode node, PersistWriter writer) {
        if (this.nodeHasSpecificMotionParameter(node)) {
            this.writeMotionNode(node, writer);
        }
        PositionNodeType type = node.getPositionNodeType();
        switch (type) {
            case UNDEFINED: {
                break;
            }
            case RELATIVE: {
                this.writePosition("relativeFromPosition", node.getRelativeFromPosition(), writer);
            }
            case FIXED: {
                Transform3D waypointFeatureToBase;
                if (!this.writePosition("position", node.getPositionReferenceClone(), writer) || (waypointFeatureToBase = ((MeasuredWaypointNode)node).getBaseToFeatureTransform()) == null) break;
                Pose6d featurePose = Pose6dTransformUtils.getPose6dEquivalentOfTransform3D((Transform3D)waypointFeatureToBase);
                writer.startNode(FEATURE_NODE);
                writer.addAttribute("pose", featurePose.toArray());
                writer.endNode();
                break;
            }
            case VARIABLE: {
                writer.writeNodeWithValue("variable", (Object)node.getInternalVariable());
            }
        }
    }

    @Override
    public boolean tryReadFromChildNode(WaypointNode node, PersistReader reader) {
        if (!super.tryReadFromChildNode(node, reader)) {
            String nodeName = reader.getNodeName();
            if (EqualsUtil.equals((Object)FEATURE_NODE, (Object)nodeName)) {
                if (reader.hasOneOfAttributes(new String[]{"pose"})) {
                    this.handleG5FeaturePose(node, reader);
                }
            } else if (EqualsUtil.equals((Object)"poseInFeatureCoordinates", (Object)nodeName)) {
                this.handleG3FeaturePose(node, reader);
            } else {
                return false;
            }
        }
        return true;
    }

    private void handleG5FeaturePose(WaypointNode node, PersistReader reader) {
        Pose6d pose6d = (Pose6d)reader.convertContainedValue(Pose6d.class);
        ((MeasuredWaypointNode)node).setBaseToFeatureTransform(Pose6dTransformUtils.getTransform3D((Pose6d)pose6d));
    }

    private void handleG3FeaturePose(WaypointNode node, PersistReader reader) {
        Pose6d poseInFeatureCoordinates = (Pose6d)reader.convertContainedValue(Pose6d.class);
        ((MeasuredWaypointNode)node).setBaseToFeatureTransform(WaypointNodeConversionHelper.calculateBaseToFeatureTransformation(node.getPose6d(), poseInFeatureCoordinates));
    }
}

