/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.lang.BijectiveEnumMap;
import com.ur.lang.EqualsUtil;
import com.ur.polyscope.internaltcp.domain.TCPReference;
import com.ur.polyscope.persistence.InvalidReference;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.move.PositionType;
import com.ur.polyscope.valueobjects.Acceleration;
import com.ur.polyscope.valueobjects.Percentage;
import com.ur.polyscope.valueobjects.Speed;
import com.ur.util.logging.Log;
import gui.program.MotionDefiningNode;
import gui.program.OptiMoveNode;
import gui.program.persistence.ChainingImporterExporter;
import gui.program.persistence.ChainingImporterExporterImpl;
import gui.program.persistence.LegacySupportImporterExporter;
import gui.program.services.geom.GeomFeatureReferenceBase;

public abstract class MotionDefiningNodeImporterExporterBase
extends ChainingImporterExporterImpl<AbstractProgramNode>
implements LegacySupportImporterExporter<AbstractProgramNode> {
    protected static final String USE_ACTIVE_TCP = "useActiveTCP";
    private static final String BLEND_RADIUS = "blendRadius";
    private static final String FEATURE = "feature";
    private static final String MOTION_TYPE = "motionType";
    private static final String POSITION_TYPE = "positionType";
    private static final String SPEED = "speed";
    private static final String ACCELERATION = "acceleration";
    private static final String TCP = "tcp";
    private static final String OPTIMOVE_ENABLED = "optimoveEnabled";
    private static final String OPTIMOVE_SPEED = "optiMoveSpeed";
    private static final String OPTIMOVE_ACCELERATION = "optiMoveAcceleration";
    private static final BijectiveEnumMap<MotionDefiningNode.MotionType, String> MOTION_TYPE_NAMES = new BijectiveEnumMap(MotionDefiningNode.MotionType.class).put((Enum)MotionDefiningNode.MotionType.JOINT_MOVE, (Object)"MoveJ").put((Enum)MotionDefiningNode.MotionType.LINEAR_MOVE, (Object)"MoveL").put((Enum)MotionDefiningNode.MotionType.PROCESS_MOVE, (Object)"MoveP").seal();
    private static final BijectiveEnumMap<PositionType, String> POSITION_TYPE_NAMES = new BijectiveEnumMap(PositionType.class).put((Enum)PositionType.JOINT_ANGLES, (Object)"JointAngles").put((Enum)PositionType.CARTESIAN_POSE, (Object)"CartesianPose").seal();

    public MotionDefiningNodeImporterExporterBase(ChainingImporterExporter<? super AbstractProgramNode> next) {
        super(next);
    }

    @Override
    public void writeToAttributes(AbstractProgramNode programNode, PersistWriter writer) {
        if (programNode instanceof MotionDefiningNode) {
            MotionDefiningNode node = (MotionDefiningNode)programNode;
            MotionDefiningNode.MotionType motionType = node.getMotionType();
            writer.addAttribute(MOTION_TYPE, (String)MOTION_TYPE_NAMES.getValue((Enum)motionType));
            writer.addAttribute(SPEED, node.getSpeed().getIn(Speed.Unit.SI));
            writer.addAttribute(ACCELERATION, node.getAcceleration().getIn(Acceleration.Unit.SI));
            if (node.isProcessMove()) {
                writer.addAttribute(BLEND_RADIUS, node.getSharedProcessMoveBlendRadius());
            }
            writer.addAttribute(USE_ACTIVE_TCP, node.isUseActiveTCP());
            PositionType positionType = node.getPositionType();
            writer.addAttribute(POSITION_TYPE, (String)POSITION_TYPE_NAMES.getValue((Enum)positionType));
            writer.addAttribute(OPTIMOVE_ENABLED, node.isUsingOptiMove());
            writer.addAttribute(OPTIMOVE_SPEED, node.getOptiMoveSpeed().getValue());
            writer.addAttribute(OPTIMOVE_ACCELERATION, node.getOptiMoveAcceleration().getValue());
        }
    }

    @Override
    public void writeToChildNodes(AbstractProgramNode programNode, PersistWriter writer) {
        if (programNode instanceof MotionDefiningNode) {
            MotionDefiningNode node = (MotionDefiningNode)programNode;
            writer.writeNodeWithValue(TCP, (Object)node.getTcpReference());
            writer.writeNodeWithTypeAndValue(FEATURE, (Object)node.getFeatureReference());
        }
    }

    @Override
    public void readFromAttributes(AbstractProgramNode programNode, PersistReader reader) {
        if (programNode instanceof MotionDefiningNode) {
            PositionType positionType;
            MotionDefiningNode node = (MotionDefiningNode)programNode;
            MotionDefiningNode.MotionType motionType = (MotionDefiningNode.MotionType)MOTION_TYPE_NAMES.getKey((Object)reader.getStringAttribute(MOTION_TYPE));
            node.setMotionType(motionType);
            if (motionType == MotionDefiningNode.MotionType.JOINT_MOVE) {
                node.setJointSpeed(reader.getDoubleAttribute(SPEED));
                node.setJointAcceleration(reader.getDoubleAttribute(ACCELERATION));
            } else {
                node.setCartesianSpeed(reader.getDoubleAttribute(SPEED));
                node.setCartesianAcceleration(reader.getDoubleAttribute(ACCELERATION));
            }
            if (motionType == MotionDefiningNode.MotionType.PROCESS_MOVE) {
                node.setSharedProcessMoveBlendRadius(reader.getDoubleAttribute(BLEND_RADIUS));
            }
            if ((positionType = (PositionType)POSITION_TYPE_NAMES.getKey((Object)reader.getStringAttribute(POSITION_TYPE))) == null) {
                positionType = PositionType.CARTESIAN_POSE;
            }
            node.setPositionType(positionType);
            this.readOptiMoveAttributes(node, reader);
        }
    }

    private void readOptiMoveAttributes(MotionDefiningNode node, PersistReader reader) {
        if (reader.hasOneOfAttributes(new String[]{OPTIMOVE_ENABLED})) {
            this.readLegacyOptiMoveAttributes(node, reader);
            this.readOptiMovePercentageAttributes(node, reader);
            this.readIndividualOptiMoveAttributes(node, reader);
            node.setUsingOptiMove(reader.getBooleanAttribute(OPTIMOVE_ENABLED));
        } else {
            node.setUsingOptiMove(false);
        }
    }

    @Deprecated
    private void readLegacyOptiMoveAttributes(OptiMoveNode node, PersistReader reader) {
        if (!reader.hasOneOfAttributes(new String[]{"optiMovePercentage"})) {
            return;
        }
        int combinedEffort = reader.getIntegerAttribute("optiMovePercentage");
        node.setOptiMoveSpeed(Percentage.from((double)((double)combinedEffort / 100.0)));
        node.setOptiMoveAcceleration(Percentage.from((double)((double)combinedEffort / 100.0)));
    }

    @Deprecated
    private void readOptiMovePercentageAttributes(OptiMoveNode node, PersistReader reader) {
        if (!reader.hasOneOfAttributes(new String[]{"optiMoveSpeedPercentage", "optiMoveAccelerationPercentage"})) {
            return;
        }
        double speed = reader.getDoubleAttribute("optiMoveSpeedPercentage");
        double acceleration = reader.getDoubleAttribute("optiMoveAccelerationPercentage");
        node.setOptiMoveSpeed(Percentage.from((double)(speed / 100.0)));
        node.setOptiMoveAcceleration(Percentage.from((double)(acceleration / 100.0)));
    }

    private void readIndividualOptiMoveAttributes(OptiMoveNode node, PersistReader reader) {
        if (!reader.hasOneOfAttributes(new String[]{OPTIMOVE_SPEED, OPTIMOVE_ACCELERATION})) {
            return;
        }
        double speed = reader.getDoubleAttribute(OPTIMOVE_SPEED);
        double acceleration = reader.getDoubleAttribute(OPTIMOVE_ACCELERATION);
        node.setOptiMoveSpeed(Percentage.from((double)speed));
        node.setOptiMoveAcceleration(Percentage.from((double)acceleration));
    }

    @Override
    public boolean tryReadFromChildNode(AbstractProgramNode programNode, PersistReader reader) {
        if (programNode instanceof MotionDefiningNode) {
            MotionDefiningNode node = (MotionDefiningNode)programNode;
            String nodeName = reader.getNodeName();
            if (EqualsUtil.equals((Object)TCP, (Object)nodeName)) {
                node.setTcpReference((TCPReference)reader.convertContainedValue(TCPReference.class));
                node.setUseActiveTCP(false);
            } else if (EqualsUtil.equals((Object)FEATURE, (Object)nodeName)) {
                this.readFeatureHandleReferences(node, reader);
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    private void readFeatureHandleReferences(MotionDefiningNode node, PersistReader reader) {
        try {
            node.setFeatureReference((GeomFeatureReferenceBase)((Object)reader.convertContainedValue(GeomFeatureReferenceBase.class)));
        }
        catch (InvalidReference ex) {
            Log.warning((String)ex.getMessage());
        }
    }
}

