/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.valueobjects.Acceleration;
import com.ur.polyscope.valueobjects.Speed;
import com.ur.swing.expression.ExpressionBranchNode;
import com.ur.util.Optional;
import gui.program.direction.DirectionsLookup;
import gui.program.direction.MoveDirectionNode;
import gui.program.persistence.ProgramNodeConversionStrategyBase;
import gui.program.services.geom.GeomFeatureReferenceBase;

class MoveDirectionNodePersistenceStrategy
extends ProgramNodeConversionStrategyBase<MoveDirectionNode> {
    public static final String EXPRESSION = "expression";
    public static final String FEATURE = "feature";
    private static final String SELECTED_DIRECTION = "selectedDirection";
    private static final String TOOL_PARAMS = "toolParams";

    public MoveDirectionNodePersistenceStrategy() {
        super(MoveDirectionNode.class);
    }

    @Override
    protected MoveDirectionNode createNode(PersistReader reader) {
        return new MoveDirectionNode();
    }

    @Override
    public void writeToAttributes(MoveDirectionNode node, PersistWriter writer) {
        if (node.getSelectedDirection().isPresent()) {
            writer.addAttribute(SELECTED_DIRECTION, (Enum)node.getSelectedDirection().get());
        }
        if (node.getToolMotionParams().isPresent()) {
            MoveDirectionNode.ToolMotionParams params = (MoveDirectionNode.ToolMotionParams)node.getToolMotionParams().get();
            writer.addAttribute(TOOL_PARAMS, new double[]{params.speed.asDouble(), params.accel.asDouble()});
        }
    }

    @Override
    public void writeToChildNodes(MoveDirectionNode node, PersistWriter writer) {
        if (node.getExpression().isPresent()) {
            writer.writeNodeWithTypeAndValue(EXPRESSION, node.getExpression().get());
        }
        if (node.getFeatureReference().isPresent()) {
            writer.writeNodeWithTypeAndValue(FEATURE, node.getFeatureReference().get());
        }
    }

    @Override
    public void readFromAttributes(MoveDirectionNode node, PersistReader reader) {
        if (reader.hasOneOfAttributes(new String[]{SELECTED_DIRECTION})) {
            node.setSelectedDirection((Optional<DirectionsLookup.Direction>)Optional.of((Object)((Object)((DirectionsLookup.Direction)reader.getEnumAttribute(SELECTED_DIRECTION, DirectionsLookup.Direction.class)))));
        }
        if (reader.hasOneOfAttributes(new String[]{TOOL_PARAMS})) {
            double[] params = reader.getDoubleArrayAttribute(TOOL_PARAMS);
            node.setToolMotionParams((Optional<MoveDirectionNode.ToolMotionParams>)Optional.of((Object)new MoveDirectionNode.ToolMotionParams(false, Speed.from((double)params[0], (Speed.Unit)Speed.Unit.SI), Acceleration.from((double)params[1], (Acceleration.Unit)Acceleration.Unit.SI))));
        }
    }

    @Override
    public boolean tryReadFromChildNode(MoveDirectionNode node, PersistReader reader) {
        String nodeName = reader.getNodeName();
        if (FEATURE.equals(nodeName)) {
            node.setFeatureReference((Optional<GeomFeatureReferenceBase>)Optional.of((Object)((Object)((GeomFeatureReferenceBase)((Object)reader.convertContainedValue(GeomFeatureReferenceBase.class))))));
            return true;
        }
        if (EXPRESSION.equals(nodeName)) {
            ExpressionBranchNode expressionBranchNode = (ExpressionBranchNode)reader.convertContainedValue(ExpressionBranchNode.class);
            node.setExpression((Optional<ExpressionBranchNode>)Optional.of((Object)expressionBranchNode));
            node.setSelectedDirection((Optional<DirectionsLookup.Direction>)Optional.empty());
            return true;
        }
        return super.tryReadFromChildNode(node, reader);
    }
}

