/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.polyscope.internaltcp.domain.TCPReference;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.pin.PinReference;
import com.ur.reference.NameReference;
import gui.program.services.ProgramReferenceService;
import gui.program.services.geom.GeomFeatureReference;
import java.util.HashMap;
import java.util.Map;

public class NameReferenceConversionStrategy
extends ConversionStrategyTemplate<NameReference<?>> {
    private static final String REFERENCED_NAME_ATTRIBUTE = "referencedName";
    private final ProgramReferenceService programReferenceService;

    public NameReferenceConversionStrategy(ProgramReferenceService programReferenceService) {
        super(NameReferenceConversionStrategy.castClass(NameReference.class));
        this.programReferenceService = programReferenceService;
    }

    public void marshal(NameReference<?> toMarshal, PersistWriter writer) {
        writer.addAttribute(REFERENCED_NAME_ATTRIBUTE, toMarshal.getKey());
    }

    public NameReference<?> unmarshal(PersistReader reader) {
        String referencedName = reader.getStringAttribute(REFERENCED_NAME_ATTRIBUTE);
        if (referencedName == null) {
            referencedName = reader.getStringAttribute("featureName");
        }
        if (referencedName == null) {
            referencedName = reader.getStringAttribute("ioName");
        }
        return this.getNameReference(reader.getRequiredType(), referencedName);
    }

    public Map<String, Class<? extends NameReference<?>>> getTypeAliases(boolean forMarshalling) {
        HashMap result = new HashMap();
        result.put("PinReference", PinReference.class);
        result.put("TCPReference", TCPReference.class);
        result.put("GeomFeatureReference", GeomFeatureReference.class);
        return result;
    }

    private <T> NameReference<T> getNameReference(Class<?> type, String stringAttribute) {
        return (NameReference)this.programReferenceService.getReference(NameReferenceConversionStrategy.castClass(type), stringAttribute);
    }

    private static <T> Class<T> castClass(Class<?> aClass) {
        return aClass;
    }
}

