/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.lang.EqualsUtil;
import com.ur.lang.naming.NamedEntityCollection;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import gui.program.AnchoredSequenceNode;
import gui.program.EntityFactory;
import gui.program.PalletNode;
import gui.program.PatternNode;
import gui.program.SpecialSequenceNode;
import gui.program.persistence.ProgramNodeConversionStrategyBase;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class PalletNodeConversionStrategy
extends ProgramNodeConversionStrategyBase<PalletNode> {
    private static final String PATTERN_NODE = "pattern";
    private static final String ACTION_SEQUENCE = "actionSequence";
    private static final String BEFORE_START = "beforeStart";
    private static final String AFTER_END = "afterEnd";
    private final EntityFactory entityFactory;

    public PalletNodeConversionStrategy(EntityFactory entityFactory) {
        super(PalletNode.class);
        this.entityFactory = entityFactory;
    }

    @Override
    public void writeToChildNodes(PalletNode node, PersistWriter writer) {
        writer.writeNodeWithValue(PATTERN_NODE, (Object)node.getPatternNode());
        writer.writeNodeWithValue(ACTION_SEQUENCE, (Object)node.getAnchoredSequenceNode());
        writer.writeNodeWithValue(BEFORE_START, (Object)node.getBeforeStartSequence());
        writer.writeNodeWithValue(AFTER_END, (Object)node.getAfterEndSequence());
    }

    @Override
    protected PalletNode createNode(PersistReader reader) {
        PalletNode result = this.entityFactory.createPalletNode();
        NamedEntityCollection collection = (NamedEntityCollection)result.getProgramEntitiesInSubtree((Collection)new NamedEntityCollection());
        this.entityFactory.getNamingService().deregisterNamedEntities(collection);
        result.removeAllChildren();
        return result;
    }

    @Override
    public boolean tryReadFromChildNode(PalletNode node, PersistReader reader) {
        String nodeName = reader.getNodeName();
        if (EqualsUtil.equals((Object)PATTERN_NODE, (Object)nodeName)) {
            node.setPatternNode((PatternNode)reader.convertContainedValue(PatternNode.class));
        } else if (EqualsUtil.equals((Object)ACTION_SEQUENCE, (Object)nodeName)) {
            node.setAnchoredSequenceNode((AnchoredSequenceNode)reader.convertContainedValue(AnchoredSequenceNode.class));
        } else if (EqualsUtil.equals((Object)BEFORE_START, (Object)nodeName)) {
            SpecialSequenceNode beforeStartSequence = (SpecialSequenceNode)reader.convertContainedValue(SpecialSequenceNode.class);
            beforeStartSequence.setType(SpecialSequenceNode.SpecialSequenceType.BEFORE_POINT);
            node.setBeforeStartSequence(beforeStartSequence);
        } else if (EqualsUtil.equals((Object)AFTER_END, (Object)nodeName)) {
            node.setAfterEndSequence((SpecialSequenceNode)reader.convertContainedValue(SpecialSequenceNode.class));
        } else {
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Class<? extends PalletNode>> getTypeAliases(boolean forMarshalling) {
        return Collections.singletonMap("Pallet", PalletNode.class);
    }
}

