/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.lang.BijectiveEnumMap;
import com.ur.lang.EqualsUtil;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.view.variables.core.ProgramVariable;
import gui.program.EntityFactory;
import gui.program.PatternNode;
import gui.program.persistence.ProgramNodeConversionStrategyBase;
import java.util.Collections;
import java.util.Map;

public class PatternNodeConversionStrategy
extends ProgramNodeConversionStrategyBase<PatternNode> {
    private static final String DIMENSIONALITY = "dimensionality";
    private static final String FIRST_AXIS_COUNT = "firstAxisCount";
    private static final String SECOND_AXIS_COUNT = "secondAxisCount";
    private static final String THIRD_AXIS_COUNT = "thirdAxisCount";
    private static final String COUNTER_VARIABLE = "counterVariable";
    private static final String PATTERN_POSE_VARIABLE = "patternPoseVariable";
    private static final BijectiveEnumMap<PatternNode.Type, String> TYPE_NAMES = new BijectiveEnumMap(PatternNode.Type.class).put((Enum)PatternNode.Type.UNDEFINED, (Object)"Undefined").put((Enum)PatternNode.Type.LIST, (Object)"List").put((Enum)PatternNode.Type.LINE, (Object)"Line").put((Enum)PatternNode.Type.SQUARE_OBSOLETE, (Object)"SquareObsolete").put((Enum)PatternNode.Type.BOX_OBSOLETE, (Object)"BoxObsolete").put((Enum)PatternNode.Type.SQUARE, (Object)"Square").put((Enum)PatternNode.Type.BOX, (Object)"Box").seal();
    private final EntityFactory entityFactory;

    public PatternNodeConversionStrategy(EntityFactory entityFactory) {
        super(PatternNode.class);
        this.entityFactory = entityFactory;
    }

    @Override
    public void writeToAttributes(PatternNode node, PersistWriter writer) {
        writer.addAttribute(DIMENSIONALITY, (String)TYPE_NAMES.getValue((Enum)node.getDimensionality()));
        writer.addAttribute(FIRST_AXIS_COUNT, node.getFirstAxisCount());
        writer.addAttribute(SECOND_AXIS_COUNT, node.getSecondAxisCount());
        writer.addAttribute(THIRD_AXIS_COUNT, node.getThirdAxisCount());
    }

    @Override
    public void writeToChildNodes(PatternNode node, PersistWriter writer) {
        writer.writeNodeWithValue(COUNTER_VARIABLE, (Object)node.getCounterVariable());
        writer.writeNodeWithValue(PATTERN_POSE_VARIABLE, (Object)node.getPatternPoseVariable());
    }

    @Override
    protected PatternNode createNode(PersistReader reader) {
        return this.entityFactory.createPatternNode();
    }

    @Override
    public void readFromAttributes(PatternNode node, PersistReader reader) {
        node.setDimensionality((PatternNode.Type)TYPE_NAMES.getKey((Object)reader.getStringAttribute(DIMENSIONALITY)));
        node.setFirstAxisCount(reader.getIntegerAttribute(FIRST_AXIS_COUNT));
        node.setSecondAxisCount(reader.getIntegerAttribute(SECOND_AXIS_COUNT));
        node.setThirdAxisCount(reader.getIntegerAttribute(THIRD_AXIS_COUNT));
    }

    @Override
    public boolean tryReadFromChildNode(PatternNode node, PersistReader reader) {
        String nodeName = reader.getNodeName();
        if (EqualsUtil.equals((Object)COUNTER_VARIABLE, (Object)nodeName)) {
            node.setCounterVariable((ProgramVariable)reader.convertContainedValue(ProgramVariable.class));
        } else if (EqualsUtil.equals((Object)PATTERN_POSE_VARIABLE, (Object)nodeName)) {
            node.setPatternPoseVariable((ProgramVariable)reader.convertContainedValue(ProgramVariable.class));
        } else {
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Class<? extends PatternNode>> getTypeAliases(boolean forMarshalling) {
        return Collections.singletonMap("Pattern", PatternNode.class);
    }
}

