/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.lang.BijectiveEnumMap;
import com.ur.lang.EqualsUtil;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.swing.dialog.MessageDialogType;
import com.ur.view.variables.core.Variable;
import gui.program.EntityFactory;
import gui.program.PopupNode;
import gui.program.persistence.ProgramNodeConversionStrategyBase;
import java.util.Collections;
import java.util.Map;

public class PopupNodeConversionStrategy
extends ProgramNodeConversionStrategyBase<PopupNode> {
    private static final String INPUT_TYPE_ATTRIBUTE = "inputType";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String HALT_PROGRAM_ATTRIBUTE = "haltProgram";
    private static final String MESSAGE_ATTRIBUTE = "message";
    private static final String VARIABLE_NODE = "variable";
    private static final BijectiveEnumMap<MessageDialogType, String> TYPE_NAMES = new BijectiveEnumMap(MessageDialogType.class).put((Enum)MessageDialogType.MESSAGE, (Object)"Message").put((Enum)MessageDialogType.WARNING, (Object)"Warning").put((Enum)MessageDialogType.ERROR, (Object)"Error").put((Enum)MessageDialogType.NONE, (Object)"None").put((Enum)MessageDialogType.QUESTION, (Object)"Question").seal();
    private static final BijectiveEnumMap<PopupNode.InputType, String> INPUT_TYPE_NAMES = new BijectiveEnumMap(PopupNode.InputType.class).put((Enum)PopupNode.InputType.TEXT, (Object)"Text").put((Enum)PopupNode.InputType.VARIABLE, (Object)"Variable").seal();
    private final EntityFactory entityFactory;

    public PopupNodeConversionStrategy(EntityFactory entityFactory) {
        super(PopupNode.class);
        this.entityFactory = entityFactory;
    }

    @Override
    public void writeToAttributes(PopupNode node, PersistWriter writer) {
        writer.addAttribute(TYPE_ATTRIBUTE, (String)TYPE_NAMES.getValue((Enum)node.getType()));
        writer.addAttribute(HALT_PROGRAM_ATTRIBUTE, node.isHaltProgram());
        writer.addAttribute(MESSAGE_ATTRIBUTE, node.getMessage());
        writer.addAttribute(INPUT_TYPE_ATTRIBUTE, (String)INPUT_TYPE_NAMES.getValue((Enum)node.getInputType()));
    }

    @Override
    public void writeToChildNodes(PopupNode node, PersistWriter writer) {
        PopupNode.InputType inputType = node.getInputType();
        if (inputType == PopupNode.InputType.VARIABLE && node.getVariable() != null) {
            writer.writeNodeWithValue(VARIABLE_NODE, (Object)node.getVariable());
        }
    }

    @Override
    public void readFromAttributes(PopupNode node, PersistReader reader) {
        node.setType((MessageDialogType)TYPE_NAMES.getKey((Object)reader.getStringAttribute(TYPE_ATTRIBUTE)));
        node.setHaltProgram(reader.getBooleanAttribute(HALT_PROGRAM_ATTRIBUTE));
        node.setMessage(reader.getStringAttribute(MESSAGE_ATTRIBUTE));
        String inputType = reader.getStringAttribute(INPUT_TYPE_ATTRIBUTE);
        if (inputType != null) {
            node.setInputType((PopupNode.InputType)INPUT_TYPE_NAMES.getKey((Object)inputType));
        }
    }

    @Override
    public boolean tryReadFromChildNode(PopupNode node, PersistReader reader) {
        String nodeName = reader.getNodeName();
        if (EqualsUtil.equals((Object)VARIABLE_NODE, (Object)nodeName)) {
            Variable variable = (Variable)reader.convertContainedValue(Variable.class);
            node.setVariable(variable);
            return true;
        }
        return false;
    }

    @Override
    protected PopupNode createNode(PersistReader reader) {
        return this.entityFactory.createPopupNode();
    }

    @Override
    public Map<String, Class<? extends PopupNode>> getTypeAliases(boolean forMarshalling) {
        return Collections.singletonMap("Popup", PopupNode.class);
    }
}

