/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import gui.program.AssignmentNode;
import gui.program.MainProgram;
import gui.program.persistence.ChainingImporterExporter;
import gui.program.persistence.ChainingImporterExporterImpl;
import javax.swing.tree.MutableTreeNode;

public class ProgramBranchNodeImporterExporter
extends ChainingImporterExporterImpl<AbstractProgramNode> {
    private static final String CHILDREN_NODE = "children";
    private boolean noInit = true;

    public ProgramBranchNodeImporterExporter(ChainingImporterExporter<? super AbstractProgramNode> next) {
        super(next);
    }

    @Override
    public void writeToChildNodes(AbstractProgramNode node, PersistWriter writer) {
        if (node.getNodeType().isChildrenAllowed() && node.getChildCount() > 0) {
            writer.startNode(CHILDREN_NODE);
            int i = 0;
            while (i < node.getChildCount()) {
                writer.writeNodeWithValue((Object)node.getChildAt(i));
                ++i;
            }
            writer.endNode();
        }
    }

    @Override
    public boolean tryReadFromChildNode(AbstractProgramNode node, PersistReader reader) {
        if (node.getNodeType().isChildrenAllowed() && EqualsUtil.equals((Object)CHILDREN_NODE, (Object)reader.getNodeName())) {
            while (reader.hasMoreNodes()) {
                reader.moveToChildNode();
                this.readChild(node, reader);
                reader.moveToParentNode();
            }
            if (node instanceof MainProgram && this.noInit) {
                MainProgram mainProgram = (MainProgram)node;
                mainProgram.setInitVarsEnabled(false);
            }
            return true;
        }
        return false;
    }

    protected void readChild(AbstractProgramNode node, PersistReader reader) {
        if (node != null && reader != null) {
            AssignmentNode assignmentNode;
            AbstractProgramNode programNode = (AbstractProgramNode)reader.convertContainedValue((Object)node, AbstractProgramNode.class);
            if (programNode instanceof AssignmentNode && (assignmentNode = (AssignmentNode)programNode).getVariable().hasExpression()) {
                this.noInit = false;
            }
            node.add((MutableTreeNode)programNode);
        }
    }
}

