/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.lang.StringUtils;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.program.ProgramComponent;
import com.ur.polyscope.program.ProgramRootNode;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentificationProvider;
import com.ur.polyscope.version.urversion.URVersion;
import com.ur.polyscope.viewfacade.program.persistence.MetaComponentConversionStrategy;
import gui.program.ProgramMetaDataComponent;
import javax.inject.Inject;

public class ProgramMetaDataComponentConversionStrategy
implements MetaComponentConversionStrategy {
    private static final String CREATED_IN_VERSION = "createdIn";
    public static final String LAST_SAVED_IN_VERSION = "lastSavedIn";
    private static final String ROBOT_SERIAL_NUMBER = "robotSerialNumber";
    private static final String CREATED_IN_POLYSCOPE_PROGRAM_VERSION = "createdInPolyscopeProgramVersion";
    private static final String LAST_SAVED_IN_POLYSCOPE_PROGRAM_VERSION = "lastSavedInPolycopeProgramVersion";
    private final RobotIdentificationProvider robotIdentificationProvider;

    @Inject
    public ProgramMetaDataComponentConversionStrategy(RobotIdentificationProvider robotIdentificationProvider) {
        this.robotIdentificationProvider = robotIdentificationProvider;
    }

    public void writeToAttributes(ProgramRootNode rootNode, PersistWriter writer) {
        ProgramMetaDataComponent component = (ProgramMetaDataComponent)rootNode.getComponent(ProgramMetaDataComponent.class);
        writer.addAttribute(CREATED_IN_VERSION, this.getVersionString(component.getCreatedInVersion()));
        writer.addAttribute(LAST_SAVED_IN_VERSION, this.getVersionString(component.getLastSavedInVersion()));
        writer.addAttribute(ROBOT_SERIAL_NUMBER, component.getRobotIdentification().getSerialNumber().getSerialNumber());
        writer.addAttribute(CREATED_IN_POLYSCOPE_PROGRAM_VERSION, component.getCreatedInPolyscopeProgramVersion());
        writer.addAttribute(LAST_SAVED_IN_POLYSCOPE_PROGRAM_VERSION, component.getLastSavedInPolyscopeProgramVersion());
    }

    public ProgramComponent readFromAttributes(PersistReader reader) {
        ProgramMetaDataComponent result = new ProgramMetaDataComponent(this.parseVersionString(reader.getStringAttribute(CREATED_IN_VERSION)), this.parseVersionString(reader.getStringAttribute(LAST_SAVED_IN_VERSION)), this.robotIdentificationProvider.fromStringHydrateProgram(reader.getStringAttribute(ROBOT_SERIAL_NUMBER)));
        if (reader.hasOneOfAttributes(new String[]{CREATED_IN_POLYSCOPE_PROGRAM_VERSION, LAST_SAVED_IN_POLYSCOPE_PROGRAM_VERSION})) {
            result.setLastSavedInPolyscopeProgramVersion(reader.getIntegerAttribute(LAST_SAVED_IN_POLYSCOPE_PROGRAM_VERSION));
            result.setCreatedInPolyscopeProgramVersion(reader.getIntegerAttribute(CREATED_IN_POLYSCOPE_PROGRAM_VERSION));
        }
        return result;
    }

    private String getVersionString(URVersion version) {
        return String.valueOf(version.getMajorVersion()) + "." + version.getMinorVersion() + "." + version.getPatchVersion();
    }

    private URVersion parseVersionString(String versionString) {
        String[] versionParts = StringUtils.split((String)".", (String)versionString);
        int major = 0;
        int minor = 0;
        int patch = 0;
        if (versionParts != null) {
            major = versionParts.length >= 1 ? Integer.parseInt(versionParts[0]) : 0;
            minor = versionParts.length >= 2 ? Integer.parseInt(versionParts[1]) : 0;
            patch = versionParts.length >= 3 ? Integer.parseInt(versionParts[2]) : 0;
        }
        return new URVersion(major, minor, patch);
    }
}

