/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.LockChildState;
import gui.program.MainProgram;
import gui.program.ProgramRootNode;
import gui.program.persistence.ChainingImporterExporter;
import gui.program.persistence.ChainingImporterExporterImpl;

public class ProgramNodeStateImporterExporter
extends ChainingImporterExporterImpl<AbstractProgramNode> {
    private static final String STATE = "state";
    private static final String IS_CHILDREN_LOCKED = "isChildrenLocked";
    private final LockChildState defaultState = new LockChildState();

    public ProgramNodeStateImporterExporter(ChainingImporterExporter<? super AbstractProgramNode> next) {
        super(next);
    }

    @Override
    public void writeToChildNodes(AbstractProgramNode node, PersistWriter writer) {
        if (this.isStateSupported(node) && !this.defaultState.equals((Object)node.getState())) {
            writer.startNode(STATE);
            this.addAttributeIfNotDefault(IS_CHILDREN_LOCKED, node.getState().isChildrenLocked(), this.defaultState.isChildrenLocked(), writer);
            writer.endNode();
        }
    }

    private void addAttributeIfNotDefault(String key, boolean value, boolean defaultValue, PersistWriter writer) {
        if (value != defaultValue) {
            writer.addAttribute(key, value);
        }
    }

    private boolean isStateSupported(AbstractProgramNode node) {
        return !(node instanceof MainProgram) && !(node instanceof ProgramRootNode);
    }

    @Override
    public boolean tryReadFromChildNode(AbstractProgramNode node, PersistReader reader) {
        String nodeName;
        if (this.isStateSupported(node) && EqualsUtil.equals((Object)STATE, (Object)(nodeName = reader.getNodeName()))) {
            if (reader.hasOneOfAttributes(new String[]{IS_CHILDREN_LOCKED})) {
                node.getState().setChildrenLocked(reader.getBooleanAttribute(IS_CHILDREN_LOCKED));
            }
            return true;
        }
        return false;
    }
}

