/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.i18n.TextResource;
import com.ur.injection.Builder;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.polyscope.persistence.CompositeConversionStrategy;
import com.ur.polyscope.persistence.ConversionStrategy;
import com.ur.polyscope.persistence.Serialization;
import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.program.nodes.until.persistence.UntilTypeConversionStrategy;
import com.ur.polyscope.program.persist.ProgramComponentConversionStrategy;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsFactory;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentificationProvider;
import com.ur.polyscope.viewfacade.program.persistence.MetaComponentConversionStrategy;
import com.ur.swing.expression.ExpressionBranchNode;
import com.ur.view.domain.program.expression.ExpressionIONode;
import com.ur.view.polyscope.module.programs.ProgramContributionProvider;
import com.ur.view.program.RegisterProgramNodeConversionStrategy;
import com.ur.view.variables.core.Variable;
import gui.program.EntityFactory;
import gui.program.WaitNode;
import gui.program.expression.persistence.ExpressionBranchNodeConversionStrategy;
import gui.program.expression.persistence.ExpressionCharNodeConversionStrategy;
import gui.program.expression.persistence.ExpressionGeomFeatureNodeConversionStrategy;
import gui.program.expression.persistence.ExpressionIONodeConversionStrategy;
import gui.program.expression.persistence.ExpressionTokenNodeConversionStrategy;
import gui.program.expression.persistence.ExpressionVariableNodeConversionStrategy;
import gui.program.expression.persistence.ExpressionWaypointNodeConversionStrategy;
import gui.program.expression.persistence_pre_v3_2.ExpressionBranchNodeConversionStrategy_v3_1;
import gui.program.expression.persistence_pre_v3_2.ExpressionCharNodeConversionStrategy_v3_1;
import gui.program.expression.persistence_pre_v3_2.ExpressionConversionStrategy_v3_1;
import gui.program.expression.persistence_pre_v3_2.ExpressionGeomFeatureNodeConversionStrategy_v3_1;
import gui.program.expression.persistence_pre_v3_2.ExpressionIONodeConversionStrategy_v3_0;
import gui.program.expression.persistence_pre_v3_2.ExpressionIONodeConversionStrategy_v3_1;
import gui.program.expression.persistence_pre_v3_2.ExpressionTokenNodeConversionStrategy_v3_1;
import gui.program.expression.persistence_pre_v3_2.ExpressionVariableNodeConversionStrategy_v3_1;
import gui.program.expression.persistence_pre_v3_2.ExpressionWaypointNodeConversionStrategy_v3_1;
import gui.program.persistence.AbstractProgramNodeConversionStrategyProxy;
import gui.program.persistence.AnchoredSequenceNodeConversionStrategy;
import gui.program.persistence.AssignmentNodeConversionStrategy;
import gui.program.persistence.CallSubProgramNodeConversionStrategy;
import gui.program.persistence.CommentNodeConversionStrategy;
import gui.program.persistence.ContributableProgramNodeConversionStrategy;
import gui.program.persistence.DirectionNodeConversionStrategy;
import gui.program.persistence.EventNodeConversionStrategy;
import gui.program.persistence.FolderNodeConversionStrategy;
import gui.program.persistence.ForceNodeConversionStrategy;
import gui.program.persistence.GeomFeatureVariableConversionStrategy;
import gui.program.persistence.HaltNodeConversionStrategy;
import gui.program.persistence.IfNodeConversionStrategy;
import gui.program.persistence.ImmiNodeConversionStrategy;
import gui.program.persistence.InitVariablesNodeConversionStrategy;
import gui.program.persistence.InstallationVariableConversionStrategy;
import gui.program.persistence.LoopNodeConversionStrategy;
import gui.program.persistence.MainProgramConversionStrategy;
import gui.program.persistence.MeasuredPositionConversionStrategy;
import gui.program.persistence.MeasuredWaypointNodeConversionStrategy;
import gui.program.persistence.MoveDirectionNodePersistenceStrategy;
import gui.program.persistence.MoveNodeConversionStrategy;
import gui.program.persistence.NameReferenceConversionStrategy;
import gui.program.persistence.PalletNodeConversionStrategy;
import gui.program.persistence.PatternNodeConversionStrategy;
import gui.program.persistence.PlaceholderNodeConversionStrategy;
import gui.program.persistence.PopupNodeConversionStrategy;
import gui.program.persistence.Pose6dConversionStrategy;
import gui.program.persistence.ProgramRootNodeConversionStrategy;
import gui.program.persistence.ProgramVariableConversionStrategy;
import gui.program.persistence.ScriptNodeConversionStrategy;
import gui.program.persistence.SetNodeConversionStrategy;
import gui.program.persistence.StackNodeConversionStrategy;
import gui.program.persistence.SubProgramNodeConversionStrategy;
import gui.program.persistence.SuppressedNodeConversionStrategy;
import gui.program.persistence.ThreadNodeConversionStrategy;
import gui.program.persistence.TimerNodeConversionStrategy;
import gui.program.persistence.UnmarshalledPositionRepresentationListener;
import gui.program.persistence.UntilNodeConversionStrategyBase;
import gui.program.persistence.VersionConversionStrategy;
import gui.program.persistence.WaitNodeConversionStrategy;
import gui.program.persistence.WaypointRepresentationUpgradeHelper;
import gui.program.persistence_pre_v3_2.AnchoredSequenceNodeConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.AssignmentNodeConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.CallSubProgramNodeConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.CircleMoveNodeConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.CommentNodeConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.DirectionNodeConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.EventNodeConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.FolderNodeConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.ForceNodeConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.GeomFeatureReferenceConversionStrategy_v3_0;
import gui.program.persistence_pre_v3_2.GeomFeatureReferenceConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.HaltNodeConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.IfNodeConversionStrategy_3_1;
import gui.program.persistence_pre_v3_2.ImmiNodeConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.InitVariablesNodeConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.LoopNodeConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.MainProgramConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.MeasuredPositionConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.MeasuredWaypointNodeConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.MoveNodeConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.PalletNodeConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.PatternNodeConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.PinConversionStrategy_v3_0;
import gui.program.persistence_pre_v3_2.PinConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.PlaceholderNodeConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.PopupNodeConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.Pose6dConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.ProgramRootNodeConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.ScriptNodeConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.SetNodeConversionStrategy_v3_0;
import gui.program.persistence_pre_v3_2.SetNodeConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.SpecialSequenceNodeConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.StackNodeConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.SubProgramNodeConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.SuppressedNodeConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.TCPReferenceConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.ThreadNodeConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.Tuple3dConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.VariableConversionStrategy_v3_0;
import gui.program.persistence_pre_v3_2.VersionConversionStrategy_v3_1;
import gui.program.persistence_pre_v3_2.WaitNodeConversionStrategy_v3_0;
import gui.program.persistence_pre_v3_2.WaitNodeConversionStrategy_v3_1;
import gui.program.services.ProgramReferenceService;
import gui.program.services.geom.GeomFeatureReference;
import gui.program.setnode.SetNode;
import gui.program.switchnode.CaseNodeConversionStrategy;
import gui.program.switchnode.SwitchNodeConversionStrategy;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;

public class ProgramPersistenceRegistry {
    private Set<ProgramComponentConversionStrategy> programNodeConverters;
    private ProgramContributionProvider programContributionProvider;
    private Set<MetaComponentConversionStrategy> metaDataConverters;
    private Set<UntilTypeConversionStrategy> untilTypeConversionStrategies;
    private Set<RegisterProgramNodeConversionStrategy> programNodeConversionStrategies;
    private Builder builder;
    private Recipe<KinematicsCalibration> calibrationRecipe;
    private KinematicsFactory kinematicsFactory;
    private IOService ioService;
    private RobotIdentificationProvider robotIdentificationProvider;

    @Inject
    public ProgramPersistenceRegistry(Set<ProgramComponentConversionStrategy> programNodeConverters, ProgramContributionProvider programContributionProvider, Set<MetaComponentConversionStrategy> metaDataConverters, Set<UntilTypeConversionStrategy> untilTypeConversionStrategies, Set<RegisterProgramNodeConversionStrategy> programNodeConversionStrategies, Builder builder, @Source(value=KinematicsCalibration.class) Recipe<KinematicsCalibration> calibrationRecipe, KinematicsFactory kinematicsFactory, IOService ioService, RobotIdentificationProvider robotIdentificationProvider) {
        this.programNodeConverters = programNodeConverters;
        this.programContributionProvider = programContributionProvider;
        this.metaDataConverters = metaDataConverters;
        this.untilTypeConversionStrategies = untilTypeConversionStrategies;
        this.programNodeConversionStrategies = programNodeConversionStrategies;
        this.builder = builder;
        this.calibrationRecipe = calibrationRecipe;
        this.kinematicsFactory = kinematicsFactory;
        this.ioService = ioService;
        this.robotIdentificationProvider = robotIdentificationProvider;
    }

    public void registerCurrentConversionStrategies(Serialization serializer, UnmarshalledPositionRepresentationListener unmarshalledPositionRepresentationListener, EntityFactory entityFactory, ProgramReferenceService programReferenceService) {
        serializer.registerConversionStrategy((ConversionStrategy)new VersionConversionStrategy());
        serializer.registerConversionStrategy((ConversionStrategy)new Pose6dConversionStrategy());
        serializer.registerConversionStrategy((ConversionStrategy)new NameReferenceConversionStrategy(programReferenceService));
        serializer.registerConversionStrategy((ConversionStrategy)new CompositeConversionStrategy<Variable>(Variable.class, entityFactory, programReferenceService){
            {
                this.add((ConversionStrategy)new ProgramVariableConversionStrategy(entityFactory));
                this.add((ConversionStrategy)new GeomFeatureVariableConversionStrategy(programReferenceService));
                this.add((ConversionStrategy)new InstallationVariableConversionStrategy(programReferenceService));
            }
        });
        serializer.registerConversionStrategy((ConversionStrategy)new ExpressionCharNodeConversionStrategy());
        serializer.registerConversionStrategy((ConversionStrategy)new ExpressionGeomFeatureNodeConversionStrategy());
        serializer.registerConversionStrategy((ConversionStrategy)new ExpressionIONodeConversionStrategy());
        serializer.registerConversionStrategy((ConversionStrategy)new ExpressionTokenNodeConversionStrategy());
        serializer.registerConversionStrategy((ConversionStrategy)new ExpressionVariableNodeConversionStrategy());
        serializer.registerConversionStrategy((ConversionStrategy)new ExpressionWaypointNodeConversionStrategy());
        serializer.registerConversionStrategy((ConversionStrategy)new ExpressionBranchNodeConversionStrategy());
        serializer.registerConversionStrategy((ConversionStrategy)new AbstractProgramNodeConversionStrategyProxy(entityFactory, this.programNodeConverters));
        serializer.registerConversionStrategy((ConversionStrategy)new AnchoredSequenceNodeConversionStrategy(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new AssignmentNodeConversionStrategy(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new TimerNodeConversionStrategy(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new CallSubProgramNodeConversionStrategy(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new CaseNodeConversionStrategy(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new CommentNodeConversionStrategy(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new ContributableProgramNodeConversionStrategy(this.programContributionProvider));
        serializer.registerConversionStrategy((ConversionStrategy)new DirectionNodeConversionStrategy(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new ImmiNodeConversionStrategy(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new FolderNodeConversionStrategy(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new EventNodeConversionStrategy(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new ForceNodeConversionStrategy(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new HaltNodeConversionStrategy(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new IfNodeConversionStrategy(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new InitVariablesNodeConversionStrategy(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new LoopNodeConversionStrategy(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new MainProgramConversionStrategy(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new MoveNodeConversionStrategy(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new PalletNodeConversionStrategy(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new PatternNodeConversionStrategy(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new PlaceholderNodeConversionStrategy(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new PopupNodeConversionStrategy(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new ProgramRootNodeConversionStrategy(entityFactory, this.metaDataConverters));
        serializer.registerConversionStrategy((ConversionStrategy)new ScriptNodeConversionStrategy(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)this.builder.get(SetNodeConversionStrategy.class));
        serializer.registerConversionStrategy((ConversionStrategy)new StackNodeConversionStrategy(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new SubProgramNodeConversionStrategy(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new SwitchNodeConversionStrategy(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new SuppressedNodeConversionStrategy(entityFactory, (TextResource)this.builder.get(TextResource.class)));
        serializer.registerConversionStrategy((ConversionStrategy)new ThreadNodeConversionStrategy(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new WaitNodeConversionStrategy(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new UntilNodeConversionStrategyBase(this.untilTypeConversionStrategies));
        serializer.registerConversionStrategy((ConversionStrategy)new MoveDirectionNodePersistenceStrategy());
        WaypointRepresentationUpgradeHelper.CachingKinematicsCalibrationConversionStrategy kinematicsCalibrationConversionStrategy = new WaypointRepresentationUpgradeHelper.CachingKinematicsCalibrationConversionStrategy((Provider<KinematicsCalibration>)this.calibrationRecipe.lastProvider(), this.kinematicsFactory);
        serializer.registerConversionStrategy((ConversionStrategy)kinematicsCalibrationConversionStrategy);
        serializer.registerConversionStrategy((ConversionStrategy)new MeasuredPositionConversionStrategy(kinematicsCalibrationConversionStrategy, unmarshalledPositionRepresentationListener, this.calibrationRecipe));
        serializer.registerConversionStrategy((ConversionStrategy)new MeasuredWaypointNodeConversionStrategy(entityFactory));
        for (RegisterProgramNodeConversionStrategy conversionStrategy : this.programNodeConversionStrategies) {
            serializer.registerConversionStrategy(conversionStrategy.getConversionStrategy());
        }
    }

    public void registerLegacyConversionStrategies(Serialization serializer, UnmarshalledPositionRepresentationListener.PositionRepresentation lastLoadedPositionRepresentation, EntityFactory entityFactory, ProgramReferenceService programReferenceService) {
        lastLoadedPositionRepresentation = UnmarshalledPositionRepresentationListener.PositionRepresentation.G3;
        serializer.registerConversionStrategy((ConversionStrategy)new VersionConversionStrategy_v3_1());
        serializer.registerConversionStrategy((ConversionStrategy)new Tuple3dConversionStrategy_v3_1());
        serializer.registerConversionStrategy((ConversionStrategy)new Pose6dConversionStrategy_v3_1());
        serializer.registerConversionStrategy((ConversionStrategy)new CompositeConversionStrategy<GeomFeatureReference>(GeomFeatureReference.class, programReferenceService){
            {
                this.add((ConversionStrategy)new GeomFeatureReferenceConversionStrategy_v3_0(programReferenceService));
                this.add((ConversionStrategy)new GeomFeatureReferenceConversionStrategy_v3_1(programReferenceService));
            }
        });
        serializer.registerConversionStrategy((ConversionStrategy)new CompositeConversionStrategy<PinReference>(PinReference.class, programReferenceService){
            {
                this.add((ConversionStrategy)new PinConversionStrategy_v3_0(programReferenceService));
                this.add((ConversionStrategy)new PinConversionStrategy_v3_1(programReferenceService));
            }
        });
        serializer.registerConversionStrategy((ConversionStrategy)new TCPReferenceConversionStrategy_v3_1(programReferenceService));
        serializer.registerConversionStrategy((ConversionStrategy)new CompositeConversionStrategy<Variable>(Variable.class, entityFactory, programReferenceService){
            {
                this.add((ConversionStrategy)new VariableConversionStrategy_v3_0(entityFactory, programReferenceService));
                this.add((ConversionStrategy)new ProgramVariableConversionStrategy(entityFactory));
                this.add((ConversionStrategy)new GeomFeatureVariableConversionStrategy(programReferenceService));
                this.add((ConversionStrategy)new InstallationVariableConversionStrategy(programReferenceService));
            }
        });
        serializer.registerConversionStrategy((ConversionStrategy)new ExpressionCharNodeConversionStrategy_v3_1());
        serializer.registerConversionStrategy((ConversionStrategy)new ExpressionGeomFeatureNodeConversionStrategy_v3_1());
        serializer.registerConversionStrategy((ConversionStrategy)new CompositeConversionStrategy<ExpressionIONode>(ExpressionIONode.class, programReferenceService){
            {
                this.add((ConversionStrategy)new ExpressionIONodeConversionStrategy_v3_0(ProgramPersistenceRegistry.this.ioService, programReferenceService));
                this.add((ConversionStrategy)new ExpressionIONodeConversionStrategy_v3_1());
            }
        });
        serializer.registerConversionStrategy((ConversionStrategy)new ExpressionTokenNodeConversionStrategy_v3_1());
        serializer.registerConversionStrategy((ConversionStrategy)new ExpressionVariableNodeConversionStrategy_v3_1());
        serializer.registerConversionStrategy((ConversionStrategy)new ExpressionWaypointNodeConversionStrategy_v3_1());
        ExpressionBranchNodeConversionStrategy_v3_1 expressionBranchNodeConversionStrategy = new ExpressionBranchNodeConversionStrategy_v3_1();
        serializer.registerConversionStrategy((ConversionStrategy)expressionBranchNodeConversionStrategy);
        serializer.registerConversionStrategy((ConversionStrategy)new ExpressionConversionStrategy_v3_1((ConversionStrategy<ExpressionBranchNode>)expressionBranchNodeConversionStrategy));
        serializer.registerConversionStrategy((ConversionStrategy)new AnchoredSequenceNodeConversionStrategy_v3_1(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new AssignmentNodeConversionStrategy_v3_1(entityFactory, programReferenceService));
        serializer.registerConversionStrategy((ConversionStrategy)new CallSubProgramNodeConversionStrategy_v3_1(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new CommentNodeConversionStrategy_v3_1(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new ContributableProgramNodeConversionStrategy(this.programContributionProvider));
        serializer.registerConversionStrategy((ConversionStrategy)new DirectionNodeConversionStrategy_v3_1(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new ImmiNodeConversionStrategy_v3_1(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new FolderNodeConversionStrategy_v3_1(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new ForceNodeConversionStrategy_v3_1(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new HaltNodeConversionStrategy_v3_1(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new IfNodeConversionStrategy_3_1(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new InitVariablesNodeConversionStrategy_v3_1(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new LoopNodeConversionStrategy_v3_1(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new MainProgramConversionStrategy_v3_1(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new MoveNodeConversionStrategy_v3_1(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new PalletNodeConversionStrategy_v3_1(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new PatternNodeConversionStrategy_v3_1(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new PlaceholderNodeConversionStrategy_v3_1(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new PopupNodeConversionStrategy_v3_1(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new ProgramRootNodeConversionStrategy_v3_1(entityFactory, this.robotIdentificationProvider));
        serializer.registerConversionStrategy((ConversionStrategy)new ScriptNodeConversionStrategy_v3_1(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new CompositeConversionStrategy<SetNode>(SetNode.class){
            {
                this.add((ConversionStrategy)ProgramPersistenceRegistry.this.builder.get(SetNodeConversionStrategy_v3_0.class));
                this.add((ConversionStrategy)ProgramPersistenceRegistry.this.builder.get(SetNodeConversionStrategy_v3_1.class));
            }
        });
        serializer.registerConversionStrategy((ConversionStrategy)new SpecialSequenceNodeConversionStrategy_v3_1(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new CircleMoveNodeConversionStrategy_v3_1(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new StackNodeConversionStrategy_v3_1(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new SubProgramNodeConversionStrategy_v3_1(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new SuppressedNodeConversionStrategy_v3_1(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new ThreadNodeConversionStrategy_v3_1(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new CompositeConversionStrategy<WaitNode>(WaitNode.class, entityFactory, programReferenceService){
            {
                this.add((ConversionStrategy)new WaitNodeConversionStrategy_v3_0(entityFactory, programReferenceService, ProgramPersistenceRegistry.this.ioService));
                this.add(new WaitNodeConversionStrategy_v3_1(entityFactory));
            }
        });
        serializer.registerConversionStrategy((ConversionStrategy)new EventNodeConversionStrategy_v3_1(entityFactory));
        serializer.registerConversionStrategy((ConversionStrategy)new UntilNodeConversionStrategyBase(this.untilTypeConversionStrategies));
        serializer.registerConversionStrategy((ConversionStrategy)new MoveDirectionNodePersistenceStrategy());
        WaypointRepresentationUpgradeHelper.CachingKinematicsCalibrationConversionStrategy_v3_1 kinematicsConversion = new WaypointRepresentationUpgradeHelper.CachingKinematicsCalibrationConversionStrategy_v3_1((Provider<KinematicsCalibration>)this.calibrationRecipe.lastProvider(), this.kinematicsFactory);
        serializer.registerConversionStrategy((ConversionStrategy)kinematicsConversion);
        serializer.registerConversionStrategy((ConversionStrategy)new MeasuredPositionConversionStrategy_v3_1(kinematicsConversion));
        serializer.registerConversionStrategy((ConversionStrategy)new MeasuredWaypointNodeConversionStrategy_v3_1(entityFactory, programReferenceService, kinematicsConversion));
    }
}

