/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.i18n.TextResource;
import com.ur.injection.Builder;
import com.ur.lang.naming.IgnoreNameChanges;
import com.ur.lang.naming.NameChangeAspect;
import com.ur.polyscope.persistence.Serialization;
import com.ur.polyscope.persistence.SerializationFacade;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.ProgramSelectionModel;
import com.ur.polyscope.program.undoredo.IgnoreProgramChanges;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.polyscope.version.urversion.URVersion;
import com.ur.polyscope.version.urversion.URVersionProvider;
import gui.polyscope.program.InsertNodeStrategy;
import gui.program.EntityFactory;
import gui.program.MoveNode;
import gui.program.ProgramMetaDataComponent;
import gui.program.ProgramRootNode;
import gui.program.expression.persistence.UnresolvedWaypoints;
import gui.program.persistence.ProgramPersistenceRegistry;
import gui.program.persistence.ProgramPersistenceStrategy$AjcClosure1;
import gui.program.persistence.ProgramPersistenceStrategy$AjcClosure3;
import gui.program.persistence.UnmarshalledPositionRepresentationListener;
import gui.program.persistence.UpgradeWaypointsComponent;
import gui.program.persistence.VersionReader;
import gui.program.persistence.WaypointRepresentationUpgradeHelper;
import gui.program.services.ProgramReferenceService;
import gui.tools.PersistStrategy;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import javax.inject.Inject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ProgramPersistenceStrategy
implements UnmarshalledPositionRepresentationListener,
PersistStrategy<ProgramRootNode> {
    protected final EntityFactory entityFactory;
    protected final ProgramReferenceService programReferenceService;
    private final URVersionProvider urVersionProvider;
    private final WaypointRepresentationUpgradeHelper waypointRepresentationUpgradeHelper;
    private final Builder builder;
    private ProgramPersistenceRegistry programPersistenceRegistry;
    private UnmarshalledPositionRepresentationListener.PositionRepresentation lastLoadedPositionRepresentation = null;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Inject
    ProgramPersistenceStrategy(EntityFactory entityFactory, ProgramReferenceService programReferenceService, URVersionProvider urVersionProvider, Builder builder, ProgramPersistenceRegistry programPersistenceRegistry) {
        this.entityFactory = entityFactory;
        this.programReferenceService = programReferenceService;
        this.urVersionProvider = urVersionProvider;
        this.builder = builder;
        this.programPersistenceRegistry = programPersistenceRegistry;
        this.waypointRepresentationUpgradeHelper = new WaypointRepresentationUpgradeHelper(entityFactory, programReferenceService);
    }

    @Override
    public void marshal(ProgramRootNode toMarshal, Writer writer) {
        ProgramMetaDataComponent programMetaDataComponent = toMarshal.getComponent(ProgramMetaDataComponent.class);
        programMetaDataComponent.setLastSavedInVersion(this.urVersionProvider.getMarketingVersion());
        programMetaDataComponent.setLastSavedInPolyscopeProgramVersion(2);
        Serialization marshaller = SerializationFacade.createMarshaller();
        marshaller.fromClass(this.getClass());
        this.registerCurrentConversionStrategies(marshaller);
        marshaller.toXML((Object)toMarshal, writer);
    }

    @Override
    @IgnoreProgramChanges
    @IgnoreNameChanges
    public ProgramRootNode unmarshal(Reader reader) throws IOException {
        Object object;
        Reader reader2 = reader;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)reader2);
        Object[] objectArray = new Object[]{this, reader2, joinPoint};
        ProgramPersistenceStrategy$AjcClosure3 programPersistenceStrategy$AjcClosure3 = new ProgramPersistenceStrategy$AjcClosure3(objectArray);
        try {
            object = ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(programPersistenceStrategy$AjcClosure3.linkStackClosureAndJoinPoint(69648));
            programPersistenceStrategy$AjcClosure3.unlink();
        }
        catch (Throwable throwable) {
            programPersistenceStrategy$AjcClosure3.unlink();
            throw throwable;
        }
        return (ProgramRootNode)object;
    }

    private void updateLegacyInitVars(ProgramRootNode program) {
        if (program.getMainProgram().isInitVarsEnabled() && !program.hasInitVariables()) {
            InsertNodeStrategy.AfterPlacementStrategy insertNodeStrategy = new InsertNodeStrategy.AfterPlacementStrategy(this.entityFactory, (TextResource)this.builder.get(TextResource.class));
            insertNodeStrategy.insertChild(this.entityFactory.createInitVariablesNode(), (AbstractProgramNode)program.getFirstChild(), 0);
            program.getComponent(ProgramSelectionModel.class).setSelected((AbstractProgramNode)program.getMainProgram());
        }
    }

    void postUnmarshal(ProgramRootNode result) {
        boolean upgradeProgram;
        this.adjustMovePRecalculateFlag(result);
        UnresolvedWaypoints.substitute(result);
        URVersion lastSavedInVersion = result.getComponent(ProgramMetaDataComponent.class).getLastSavedInVersion();
        int lastSavedInPolyscopeProgramVersion = result.getComponent(ProgramMetaDataComponent.class).getLastSavedInPolyscopeProgramVersion();
        if (this.lastLoadedPositionRepresentation == null) {
            upgradeProgram = lastSavedInVersion.getMajorVersion() < 5 && lastSavedInPolyscopeProgramVersion == 0;
        } else {
            boolean bl = upgradeProgram = this.lastLoadedPositionRepresentation == UnmarshalledPositionRepresentationListener.PositionRepresentation.G3;
        }
        if (upgradeProgram) {
            result.setComponent(new UpgradeWaypointsComponent());
            this.waypointRepresentationUpgradeHelper.upgradeProgram(result);
        }
        if (lastSavedInVersion.getMajorVersion() < 5 || lastSavedInVersion.getMajorVersion() == 5 && lastSavedInVersion.getMinorVersion() < 5) {
            this.waypointRepresentationUpgradeHelper.adjustWaypointsWithBaseFeature(result);
        }
    }

    private void adjustMovePRecalculateFlag(ProgramRootNode result) {
        if (URVersion.isLessThan((URVersion)result.getComponent(ProgramMetaDataComponent.class).getLastSavedInVersion(), (URVersion)URVersion.POLYSCOPE_VERSION_3_1)) {
            Enumeration nodes = result.breadthFirstEnumeration();
            while (nodes.hasMoreElements()) {
                Object each = nodes.nextElement();
                if (!(each instanceof MoveNode) || !((MoveNode)each).isProcessMove()) continue;
                MoveNode moveNode = (MoveNode)each;
                moveNode.setUseActiveTCP(true);
            }
        }
    }

    @Override
    public void positionRepresentationIdentified(UnmarshalledPositionRepresentationListener.PositionRepresentation positionRepresentation) {
        this.lastLoadedPositionRepresentation = positionRepresentation;
    }

    public void registerCurrentConversionStrategies(Serialization serializer) {
        this.programPersistenceRegistry.registerCurrentConversionStrategies(serializer, this, this.entityFactory, this.programReferenceService);
    }

    public void registerLegacyConversionStrategies(Serialization serializer) {
        this.programPersistenceRegistry.registerLegacyConversionStrategies(serializer, this.lastLoadedPositionRepresentation, this.entityFactory, this.programReferenceService);
    }

    static {
        ProgramPersistenceStrategy.ajc$preClinit();
    }

    static final /* synthetic */ ProgramRootNode unmarshal_aroundBody0(ProgramPersistenceStrategy ajc$this, Reader reader, JoinPoint joinPoint) {
        VersionReader versionReader = new VersionReader();
        reader = versionReader.readVersionAndPushBack(reader);
        URVersion version = versionReader.getVersion();
        Serialization unmarshaller = SerializationFacade.createUnmarshaller();
        unmarshaller.fromClass(ajc$this.getClass());
        if (version == null) {
            ajc$this.registerLegacyConversionStrategies(unmarshaller);
        } else {
            ajc$this.registerCurrentConversionStrategies(unmarshaller);
        }
        ProgramRootNode result = (ProgramRootNode)unmarshaller.fromXML(reader);
        ajc$this.updateLegacyInitVars(result);
        ProgramRootNode.setProgramRoot(result, result);
        ajc$this.postUnmarshal(result);
        return result;
    }

    static final /* synthetic */ ProgramRootNode unmarshal_aroundBody2(ProgramPersistenceStrategy programPersistenceStrategy, Reader reader, JoinPoint joinPoint) {
        Object object;
        Object[] objectArray = new Object[]{programPersistenceStrategy, reader, joinPoint};
        ProgramPersistenceStrategy$AjcClosure1 programPersistenceStrategy$AjcClosure1 = new ProgramPersistenceStrategy$AjcClosure1(objectArray);
        try {
            object = NameChangeAspect.aspectOf().aroundAnnotatedMethod(programPersistenceStrategy$AjcClosure1.linkStackClosureAndJoinPoint(69648));
            programPersistenceStrategy$AjcClosure1.unlink();
        }
        catch (Throwable throwable) {
            programPersistenceStrategy$AjcClosure1.unlink();
            throw throwable;
        }
        return (ProgramRootNode)object;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ProgramPersistenceStrategy.java", ProgramPersistenceStrategy.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "unmarshal", "gui.program.persistence.ProgramPersistenceStrategy", "java.io.Reader", "reader", "java.io.IOException", "gui.program.ProgramRootNode"), 66);
    }
}

