/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.program.ProgramComponent;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import com.ur.polyscope.viewfacade.program.persistence.MetaComponentConversionStrategy;
import gui.program.EntityFactory;
import gui.program.MainProgram;
import gui.program.ProgramRootNode;
import gui.program.calibration.KinematicDataComponent;
import gui.program.persistence.ProgramNodeConversionStrategyBase;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.TreeNode;

public class ProgramRootNodeConversionStrategy
extends ProgramNodeConversionStrategyBase<ProgramRootNode> {
    public static final String UR_PROGRAM = "URProgram";
    public static final String NAME = "name";
    private static final String KINEMATICS = "kinematics";
    public static final String CRC_VALUE = "crcValue";
    private final EntityFactory entityFactory;
    private final Set<MetaComponentConversionStrategy> programComponentMap;

    public ProgramRootNodeConversionStrategy(EntityFactory entityFactory, Set<MetaComponentConversionStrategy> programComponentMap) {
        super(ProgramRootNode.class);
        this.entityFactory = entityFactory;
        this.programComponentMap = programComponentMap;
    }

    @Override
    public void writeToAttributes(ProgramRootNode node, PersistWriter writer) {
        writer.addAttribute(NAME, node.getName());
        for (MetaComponentConversionStrategy each : this.programComponentMap) {
            each.writeToAttributes((com.ur.polyscope.program.ProgramRootNode)node, writer);
        }
    }

    @Override
    public void writeToChildNodes(ProgramRootNode node, PersistWriter writer) {
        writer.writeNodeWithValue(KINEMATICS, (Object)node.getComponent(KinematicDataComponent.class).getKinematics());
    }

    @Override
    protected ProgramRootNode createNode(PersistReader reader) {
        ProgramRootNode result = this.entityFactory.createProgramRootNode();
        result.removeAllChildren();
        return result;
    }

    @Override
    public void readFromAttributes(ProgramRootNode node, PersistReader reader) {
        for (MetaComponentConversionStrategy each : this.programComponentMap) {
            ProgramComponent component = each.readFromAttributes(reader);
            node.setComponent(component);
        }
        node.setName(reader.getStringAttribute(NAME));
    }

    @Override
    public boolean tryReadFromChildNode(ProgramRootNode node, PersistReader reader) {
        String nodeName = reader.getNodeName();
        if (!EqualsUtil.equals((Object)KINEMATICS, (Object)nodeName)) {
            return false;
        }
        node.setComponent(new KinematicDataComponent((KinematicsCalibration)reader.convertContainedValue(KinematicsCalibration.class)));
        return true;
    }

    @Override
    protected void finalizeNode(ProgramRootNode result) {
        int i = 0;
        while (i < result.getChildCount()) {
            TreeNode child = result.getChildAt(i);
            if (child instanceof MainProgram) {
                result.setMainProgram((MainProgram)((Object)child));
            }
            ++i;
        }
    }

    @Override
    public Map<String, Class<? extends ProgramRootNode>> getTypeAliases(boolean forMarshalling) {
        return Collections.singletonMap(UR_PROGRAM, ProgramRootNode.class);
    }
}

