/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.injection.Builder;
import com.ur.polyscope.persistence.ConversionStrategy;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.view.program.RegisterProgramNodeConversionStrategy;
import gui.program.AdvancedPositionOptionType;
import gui.program.SafeHomeNode;
import gui.program.persistence.ProgramNodeConversionStrategyBase;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;

public class SafeHomeNodeConversionStrategy
extends ProgramNodeConversionStrategyBase<SafeHomeNode>
implements RegisterProgramNodeConversionStrategy {
    static final String SPEED = "speed";
    static final String ACCELERATION = "acceleration";
    static final String POSITION_OPTION_TYPE = "positionOptionType";
    static final String TIME = "nextMotionTime";
    private final Builder builder;

    @Inject
    public SafeHomeNodeConversionStrategy(Builder builder) {
        super(SafeHomeNode.class);
        this.builder = builder;
    }

    @Override
    public ConversionStrategy<? extends AbstractProgramNode> getConversionStrategy() {
        return this;
    }

    @Override
    public void writeToAttributes(SafeHomeNode node, PersistWriter writer) {
        writer.addAttribute(POSITION_OPTION_TYPE, (Enum)node.getAdvancedPositionOptionType());
        writer.addAttribute(SPEED, node.getSpeed());
        writer.addAttribute(ACCELERATION, node.getAcceleration());
        writer.addAttribute(TIME, node.getMotionTime());
    }

    @Override
    public void readFromAttributes(SafeHomeNode node, PersistReader reader) {
        node.setAdvancedPositionOptionType((AdvancedPositionOptionType)reader.getEnumAttribute(POSITION_OPTION_TYPE, AdvancedPositionOptionType.class));
        node.setSpeed(reader.getDoubleAttribute(SPEED));
        node.setAcceleration(reader.getDoubleAttribute(ACCELERATION));
        node.setMotionTime(reader.getDoubleAttribute(TIME));
    }

    @Override
    protected SafeHomeNode createNode(PersistReader reader) {
        return (SafeHomeNode)this.builder.get(SafeHomeNode.class);
    }

    @Override
    public Map<String, Class<? extends SafeHomeNode>> getTypeAliases(boolean forMarshalling) {
        return Collections.singletonMap("SafeHome", SafeHomeNode.class);
    }
}

