/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.lang.BijectiveEnumMap;
import com.ur.lang.EqualsUtil;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.swing.expression.ExpressionBranchNode;
import gui.program.EntityFactory;
import gui.program.ScriptNode;
import gui.program.persistence.ProgramNodeConversionStrategyBase;
import java.io.File;
import java.util.Collections;
import java.util.Map;

public class ScriptNodeConversionStrategy
extends ProgramNodeConversionStrategyBase<ScriptNode> {
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String EXPRESSION_NODE = "expression";
    private static final String CACHED_CONTENTS_NODE = "cachedContents";
    private static final String FILE_NODE = "file";
    private static final BijectiveEnumMap<ScriptNode.Type, String> TYPE_NAMES = new BijectiveEnumMap(ScriptNode.Type.class).put((Enum)ScriptNode.Type.LINE_TYPE, (Object)"Line").put((Enum)ScriptNode.Type.FILE_TYPE, (Object)"File").seal();
    private final EntityFactory entityFactory;

    public ScriptNodeConversionStrategy(EntityFactory entityFactory) {
        super(ScriptNode.class);
        this.entityFactory = entityFactory;
    }

    @Override
    public void writeToAttributes(ScriptNode node, PersistWriter writer) {
        ScriptNode.Type type = node.getType();
        writer.addAttribute(TYPE_ATTRIBUTE, (String)TYPE_NAMES.getValue((Enum)type));
    }

    @Override
    public void writeToChildNodes(ScriptNode node, PersistWriter writer) {
        ScriptNode.Type type = node.getType();
        if (type == ScriptNode.Type.LINE_TYPE) {
            this.writeExpression(node, writer);
        } else if (type == ScriptNode.Type.FILE_TYPE) {
            this.writeCachedContents(node, writer);
            this.writeScriptFile(node, writer);
        }
    }

    @Override
    protected ScriptNode createNode(PersistReader reader) {
        return this.entityFactory.createScriptNode();
    }

    @Override
    public void readFromAttributes(ScriptNode node, PersistReader reader) {
        ScriptNode.Type type = (ScriptNode.Type)TYPE_NAMES.getKey((Object)reader.getStringAttribute(TYPE_ATTRIBUTE));
        node.setType(type);
    }

    @Override
    public boolean tryReadFromChildNode(ScriptNode node, PersistReader reader) {
        ScriptNode.Type type = node.getType();
        String nodeName = reader.getNodeName();
        if (EqualsUtil.equals((Object)EXPRESSION_NODE, (Object)nodeName) && type == ScriptNode.Type.LINE_TYPE) {
            this.readExpression(reader, node);
        } else if (EqualsUtil.equals((Object)CACHED_CONTENTS_NODE, (Object)nodeName) && type == ScriptNode.Type.FILE_TYPE) {
            this.readCachedContents(reader, node);
        } else if (EqualsUtil.equals((Object)FILE_NODE, (Object)nodeName) && type == ScriptNode.Type.FILE_TYPE) {
            this.readFile(reader, node);
        } else {
            return false;
        }
        return true;
    }

    @Override
    protected void finalizeNode(ScriptNode node) {
        node.setLoadedFileContentHasChanged(false);
    }

    private void writeExpression(ScriptNode node, PersistWriter writer) {
        writer.writeNodeWithValue(EXPRESSION_NODE, (Object)node.getExpression());
    }

    private void readExpression(PersistReader reader, ScriptNode result) {
        result.setExpression((ExpressionBranchNode)reader.convertContainedValue(ExpressionBranchNode.class));
    }

    private void writeCachedContents(ScriptNode node, PersistWriter writer) {
        writer.startNode(CACHED_CONTENTS_NODE);
        writer.addValue(node.getLoadedFileContents());
        writer.endNode();
    }

    private void readCachedContents(PersistReader reader, ScriptNode result) {
        result.setLoadedFileContents(reader.getStringValue());
    }

    private void writeScriptFile(ScriptNode node, PersistWriter writer) {
        writer.writeNodeWithValue(FILE_NODE, (Object)node.getFile().getAbsolutePath());
    }

    private void readFile(PersistReader reader, ScriptNode result) {
        result.setFile(new File(reader.getStringValue()));
    }

    @Override
    public Map<String, Class<? extends ScriptNode>> getTypeAliases(boolean forMarshalling) {
        return Collections.singletonMap("Script", ScriptNode.class);
    }
}

