/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.lang.BijectiveEnumMap;
import com.ur.math.Time;
import com.ur.polyscope.application.PersistComponent;
import com.ur.polyscope.persistence.ConversionStrategy;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.pin.PinReference;
import gui.program.EntityFactory;
import gui.program.persistence_pre_v3_2.SetNodeConversionStrategy_v3_1;
import gui.program.setnode.SetNode;
import gui.program.setnode.SingleDigitalPulseActionState;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;

public class SetNodeConversionStrategy
extends SetNodeConversionStrategy_v3_1 {
    private static final BijectiveEnumMap<SetNode.Type, String> TYPE_NAMES = new BijectiveEnumMap(SetNode.Type.class).put((Enum)SetNode.Type.UNDEFINED, (Object)"Undefined").put((Enum)SetNode.Type.NO_ACTION, (Object)"NoAction").put((Enum)SetNode.Type.DIGITAL_OUTPUT_ACTION, (Object)"DigitalOutput").put((Enum)SetNode.Type.ANALOG_OUTPUT_ACTION, (Object)"AnalogOutput").put((Enum)SetNode.Type.EXPRESSION_OUTPUT_ACTION, (Object)"ExpressionOutput").put((Enum)SetNode.Type.INCREMENT_VARIABLE, (Object)"IncrementVariable").put((Enum)SetNode.Type.SINGLE_DIGITAL_PULSE, (Object)"SingleDigitalPulseActionState").seal();

    @Inject
    public SetNodeConversionStrategy(EntityFactory entityFactory, @Named(value="payload-with-cog") @Named(value="payload-with-cog") PersistComponent payloadComponent, @Named(value="tcp-reference") @Named(value="tcp-reference") ConversionStrategy tcpComponent) {
        super(entityFactory, payloadComponent, tcpComponent);
    }

    @Override
    public void writeToAttributes(SetNode node, PersistWriter writer) {
        writer.addAttribute("type", (String)TYPE_NAMES.getValue((Enum)node.getType()));
        this.writePayload(node, writer);
    }

    @Override
    public void readFromAttributes(SetNode node, PersistReader reader) {
        node.setType((SetNode.Type)TYPE_NAMES.getKey((Object)reader.getStringAttribute("type")));
        this.readPayload(node, reader);
    }

    @Override
    public Map<String, Class<? extends SetNode>> getTypeAliases(boolean forMarshalling) {
        HashMap<String, Class<? extends SetNode>> result = new HashMap<String, Class<? extends SetNode>>();
        result.put("Set", SetNode.class);
        return result;
    }

    @Override
    public void writeToChildNodes(SetNode node, PersistWriter writer) {
        super.writeToChildNodes(node, writer);
        if (node.getType() == SetNode.Type.SINGLE_DIGITAL_PULSE) {
            writer.startNode((String)TYPE_NAMES.getValue((Enum)SetNode.Type.SINGLE_DIGITAL_PULSE));
            writer.addAttribute("hiPulseInSeconds", node.getSingleDigitalPulseActionState().getTime().asDouble());
            this.writePinReference(node.getSingleDigitalPulseActionState().getPinReference(), writer);
            writer.endNode();
        }
    }

    @Override
    public boolean tryReadFromChildNode(SetNode node, PersistReader reader) {
        boolean handledBySuper = super.tryReadFromChildNode(node, reader);
        if (!handledBySuper && this.isSingleDigitalPulse(reader)) {
            return this.handleSingleDigitalPulse(node, reader);
        }
        return false;
    }

    private boolean handleSingleDigitalPulse(SetNode node, PersistReader reader) {
        double time = reader.getDoubleAttribute("hiPulseInSeconds", SingleDigitalPulseActionState.DEFAULT_PULSE_TIME.asDouble());
        PinReference pinReference = this.readPinReferenceFromChildOrNull(reader);
        node.setSingleDigitalPulseActionState(new SingleDigitalPulseActionState(pinReference, Time.from((double)time, (Time.Unit)Time.Unit.SECONDS)));
        return true;
    }

    private PinReference readPinReferenceFromChildOrNull(PersistReader reader) {
        PinReference pinReference = null;
        if (reader.hasMoreNodes()) {
            pinReference = this.readPinReferenceFromChild(reader);
        }
        return pinReference;
    }

    private PinReference readPinReferenceFromChild(PersistReader reader) {
        reader.moveToChildNode();
        PinReference pinReference = this.readPinReference(reader);
        reader.moveToParentNode();
        return pinReference;
    }

    private boolean isSingleDigitalPulse(PersistReader reader) {
        return reader.isNode((String)TYPE_NAMES.getValue((Enum)SetNode.Type.SINGLE_DIGITAL_PULSE));
    }
}

