/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.lang.BijectiveEnumMap;
import com.ur.lang.EqualsUtil;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.swing.expression.ExpressionBranchNode;
import com.ur.view.variables.core.ProgramVariable;
import gui.program.AnchoredSequenceNode;
import gui.program.EntityFactory;
import gui.program.SpecialSequenceNode;
import gui.program.StackNode;
import gui.program.persistence.ProgramNodeConversionStrategyBase;
import java.util.Collections;
import java.util.Map;

public class StackNodeConversionStrategy
extends ProgramNodeConversionStrategyBase<StackNode> {
    private static final String TYPE = "type";
    private static final String ITEM_THICKNESS = "itemThickness";
    private static final String NEXT_POSITION_EXPRESSION = "nextPositionExpression";
    private static final String FOUND_POSE_VARIABLE = "foundPoseVariable";
    private static final String ACTION_SEQUENCE = "actionSequence";
    private static final String BEFORE_START = "beforeStart";
    private static final String AFTER_END = "afterEnd";
    static final BijectiveEnumMap<StackNode.Type, String> TYPE_NAMES = new BijectiveEnumMap(StackNode.Type.class).put((Enum)StackNode.Type.UNDEFINED, (Object)"Undefined").put((Enum)StackNode.Type.STACK, (Object)"Stack").put((Enum)StackNode.Type.DESTACK, (Object)"Destack").seal();
    private final EntityFactory entityFactory;

    public StackNodeConversionStrategy(EntityFactory entityFactory) {
        super(StackNode.class);
        this.entityFactory = entityFactory;
    }

    @Override
    public void writeToAttributes(StackNode node, PersistWriter writer) {
        writer.addAttribute(TYPE, (String)TYPE_NAMES.getValue((Enum)node.getType()));
        writer.addAttribute(ITEM_THICKNESS, node.getItemThickness());
    }

    @Override
    public void writeToChildNodes(StackNode node, PersistWriter writer) {
        writer.writeNodeWithValue(NEXT_POSITION_EXPRESSION, (Object)node.getExpression());
        writer.writeNodeWithValue(FOUND_POSE_VARIABLE, (Object)node.getFoundPoseVariable());
        writer.writeNodeWithValue(ACTION_SEQUENCE, (Object)node.getActionSequence());
        writer.writeNodeWithValue(BEFORE_START, (Object)node.getBeforeStartSequence());
        writer.writeNodeWithValue(AFTER_END, (Object)node.getAfterEndSequence());
    }

    @Override
    protected StackNode createNode(PersistReader reader) {
        return this.entityFactory.createStackNode();
    }

    @Override
    public void readFromAttributes(StackNode node, PersistReader reader) {
        node.setType((StackNode.Type)TYPE_NAMES.getKey((Object)reader.getStringAttribute(TYPE)));
        node.setItemThickness(reader.getDoubleAttribute(ITEM_THICKNESS));
    }

    @Override
    public boolean tryReadFromChildNode(StackNode node, PersistReader reader) {
        String nodeName = reader.getNodeName();
        if (EqualsUtil.equals((Object)NEXT_POSITION_EXPRESSION, (Object)nodeName)) {
            node.setExpression((ExpressionBranchNode)reader.convertContainedValue(ExpressionBranchNode.class));
        } else if (EqualsUtil.equals((Object)FOUND_POSE_VARIABLE, (Object)nodeName)) {
            node.setFoundPoseVariable((ProgramVariable)reader.convertContainedValue(ProgramVariable.class));
        } else if (EqualsUtil.equals((Object)ACTION_SEQUENCE, (Object)nodeName)) {
            node.setActionSequence((AnchoredSequenceNode)reader.convertContainedValue(AnchoredSequenceNode.class));
        } else if (EqualsUtil.equals((Object)BEFORE_START, (Object)nodeName)) {
            SpecialSequenceNode beforeStartSequence = (SpecialSequenceNode)reader.convertContainedValue(SpecialSequenceNode.class);
            beforeStartSequence.setType(SpecialSequenceNode.SpecialSequenceType.BEFORE_POINT);
            node.setBeforeStartSequence(beforeStartSequence);
        } else if (EqualsUtil.equals((Object)AFTER_END, (Object)nodeName)) {
            node.setAfterEndSequence((SpecialSequenceNode)reader.convertContainedValue(SpecialSequenceNode.class));
        } else {
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Class<? extends StackNode>> getTypeAliases(boolean forMarshalling) {
        return Collections.singletonMap("Stack", StackNode.class);
    }
}

