/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import gui.program.EntityFactory;
import gui.program.SubProgramNode;
import gui.program.persistence.ProgramNodeConversionStrategyBase;
import java.io.File;
import java.util.Collections;
import java.util.Map;

public class SubProgramNodeConversionStrategy
extends ProgramNodeConversionStrategyBase<SubProgramNode> {
    private static final String NAME = "name";
    private static final String KEEP_HIDDEN = "keepHidden";
    private static final String KEEP_SYNCHRONIZED_WITH_DISK = "keepSynchronizedWithDisk";
    private static final String PROGRAM_FILE = "programFile";
    private final EntityFactory entityFactory;

    public SubProgramNodeConversionStrategy(EntityFactory entityFactory) {
        super(SubProgramNode.class);
        this.entityFactory = entityFactory;
    }

    @Override
    public void writeToAttributes(SubProgramNode node, PersistWriter writer) {
        writer.addAttribute(NAME, node.getName());
        writer.addAttribute(KEEP_HIDDEN, node.getKeepHidden());
        writer.addAttribute(KEEP_SYNCHRONIZED_WITH_DISK, node.isKeepSynchronizedWithDisk());
    }

    @Override
    public void writeToChildNodes(SubProgramNode node, PersistWriter writer) {
        writer.writeNodeWithValue(PROGRAM_FILE, (Object)node.getFile());
    }

    @Override
    protected SubProgramNode createNode(PersistReader reader) {
        SubProgramNode result = this.entityFactory.createSubProgramNode();
        result.removeAllChildren();
        return result;
    }

    @Override
    public void readFromAttributes(SubProgramNode node, PersistReader reader) {
        node.setName(reader.getStringAttribute(NAME));
        node.setKeepHidden(reader.getBooleanAttribute(KEEP_HIDDEN));
        node.setKeepSynchronizedWithDisk(reader.getBooleanAttribute(KEEP_SYNCHRONIZED_WITH_DISK));
    }

    @Override
    public boolean tryReadFromChildNode(SubProgramNode node, PersistReader reader) {
        if (EqualsUtil.equals((Object)PROGRAM_FILE, (Object)reader.getNodeName())) {
            node.setFile((File)reader.convertContainedValue(File.class));
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Class<? extends SubProgramNode>> getTypeAliases(boolean forMarshalling) {
        return Collections.singletonMap("SubProgram", SubProgramNode.class);
    }
}

