/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.i18n.TextResource;
import com.ur.lang.EqualsUtil;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import gui.program.CommentNode;
import gui.program.EntityFactory;
import gui.program.SuppressedNode;
import gui.program.persistence.ProgramNodeConversionStrategyBase;
import java.util.Collections;
import java.util.Map;

public class SuppressedNodeConversionStrategy
extends ProgramNodeConversionStrategyBase<SuppressedNode> {
    private static final Logger LOGGER = LogFactory.createLogger(SuppressedNodeConversionStrategy.class);
    private static final String COMMENT_ATTRIBUTE = "comment";
    private static final String SUPPRESSED_NODE = "suppressedNode";
    private final EntityFactory entityFactory;
    private final TextResource textResource;

    public SuppressedNodeConversionStrategy(EntityFactory entityFactory, TextResource textResource) {
        super(SuppressedNode.class);
        this.entityFactory = entityFactory;
        this.textResource = textResource;
    }

    @Override
    public void writeToAttributes(SuppressedNode node, PersistWriter writer) {
        this.writeComment(node, writer);
    }

    @Override
    public void writeToChildNodes(SuppressedNode node, PersistWriter writer) {
        writer.writeNodeWithTypeAndValue(SUPPRESSED_NODE, (Object)node.getSuppressedNode());
    }

    @Override
    protected SuppressedNode createNode(PersistReader reader) {
        return this.entityFactory.createSuppressedNode(null);
    }

    @Override
    public void readFromAttributes(SuppressedNode node, PersistReader reader) {
        this.readComment(node, reader);
    }

    @Override
    public boolean tryReadFromChildNode(SuppressedNode node, PersistReader reader) {
        if (EqualsUtil.equals((Object)SUPPRESSED_NODE, (Object)reader.getNodeName())) {
            AbstractProgramNode programNode = (AbstractProgramNode)reader.convertContainedValue(AbstractProgramNode.class);
            this.handleChildProgramNode(node, programNode, reader);
            return true;
        }
        return false;
    }

    private void handleChildProgramNode(SuppressedNode node, AbstractProgramNode programNode, PersistReader reader) {
        if (programNode == null) {
            programNode = this.createCommentNodeForUnknownOriginalProgramNode();
            LOGGER.error("Could not interpret child program node for the suppressedNode class: '" + reader.getStringAttribute("class") + "'. " + "Inserting CommentNode as fallback", new Object[0]);
        }
        node.setSuppressedNode(programNode);
    }

    private CommentNode createCommentNodeForUnknownOriginalProgramNode() {
        CommentNode commentNode = new CommentNode();
        commentNode.setCommentString(this.textResource.unknownChildNodeForSuppressedNode());
        return commentNode;
    }

    @Override
    public Map<String, Class<? extends SuppressedNode>> getTypeAliases(boolean forMarshalling) {
        return Collections.singletonMap("SuppressedNode", SuppressedNode.class);
    }

    private void writeComment(SuppressedNode node, PersistWriter writer) {
        writer.addAttribute(COMMENT_ATTRIBUTE, node.getCommentString());
    }

    private void readComment(SuppressedNode result, PersistReader reader) {
        String comment = reader.getStringAttribute(COMMENT_ATTRIBUTE);
        if (comment != null) {
            result.setCommentString(comment);
        }
    }
}

